<?php
if (
	!isset($permissions['customers']['view_index']['main'])
	|| isset($permissions['customers']['view_index']['main'])
	&& $permissions['customers']['view_index']['main'] == 0
) redirect('admin/dashboard');
?>

<script src="https://www.chartjs.org/dist/2.9.3/Chart.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/utils.js"></script>
<div id="main" role="main">
	<div id="content">
		<div class="container-sm">
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-10 col-lg-10">
					<h1 class="text-white">
						<i class="fa fa-users fa-fw "></i>
						<?php echo $this->lang->line('customers'); ?>
						<span>>
							<?php print $mode ?><?php echo" " . $this->lang->line('customer')  ?> <?php if($customer->customerName):?> "<?php print $customer->customerName ?>"<?php endif; ?>
						</span>
					</h1>
				</div>
				<div class="col-xs-12 col-sm-12 col-md-2 col-lg-2 text-right">
					<div class="btn-group">
						<?php if ($mode == 'עריכת') : ?>
							<?php if (isset($permissions['customers']['view_index']['customer-login-as']) && $permissions['customers']['view_index']['customer-login-as'] == 1) { ?>
								<a class="btn btn-success header-btn" href="<?php print site_url() ?>admin/customers/customerPrice/<?php echo $customer->customerId; ?>" title="<?php echo $this->lang->line('customer_card'); ?>" target="_blank"><i class="fa fa-user"></i><?php echo $this->lang->line('customer_card'); ?></a>
							<?php }; ?>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<hr>
			<?php if ($this->session->flashdata('flashMsgType') == 'Success') : ?>
				<div class="alert alert-success in"><button class="close" data-bs-dismiss="alert">×</button><i class="fa-fw fa fa-check"></i>
					<strong><?php print $this->session->flashdata('flashMsgType') ?></strong> <?php print $this->session->flashdata('flashMsg') ?>
				</div>
			<?php elseif ($this->session->flashdata('flashMsgType') == 'Error') : ?>
				<div class="alert alert-danger in"><button class="close" data-bs-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>
					<strong><?php print $this->session->flashdata('flashMsgType') ?></strong> <?php print $this->session->flashdata('flashMsg') ?>
				</div>
			<?php endif; ?>
			<!-- <?php if ($customer->parentId != getAdminId() && $mode == 'עריכת') : ?>
				<div class="alert alert-info in">
					<i class="fa-fw fa fa-exclamation"></i>
					<?php echo $this->lang->line('associated_customer'); ?> <strong><a href="<?php print site_url(); ?>admin/customers/customerForm/<?php print $customer->parentId; ?>"><?php print getCustomerName($customer->parentId); ?></a></strong>
				</div>
			<?php endif; ?> -->
			<!-- <style>
			@media only screen and (max-width: 600px) {
				#customer-form {
					align-items: unset !important;
				}
			}	
		</style> -->
			<form id="customer-form" novalidate="novalidate" method="post" action="<?php print site_url(); ?>admin/customers/customerAction">
				<input type="hidden" id="customerId" class="form-control text-center" name="customerId" value="<?php echo $customer->customerId ?>" />
				<div class="row justify-content-between">
					<?php if (isset($permissions['customers']['view_index']['customers-main-details']) && $permissions['customers']['view_index']['customers-main-details'] == 1) { ?>
						<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 mb-3">
							<div class="bg-white p-3 rounded-xl shadow">
								<div class="form-group">
									<label class="input">
										<?php echo $this->lang->line('customer_name'); ?>
									</label>
									<input type="text" name="customername" class="form-control w-100 text-center" placeholder="<?php echo $this->lang->line('customer_name'); ?>" value="<?php print $customer->customerName ?>">
								</div>
								<div class="form-group">
									<label class="input">
										<?php echo $this->lang->line('contact_person'); ?>
									</label>
									<input type="text" name="customerName" class="form-control w-100 text-center" placeholder="<?php echo $this->lang->line('contact_person'); ?>" value="<?php print $customer->customerName ?>">
								</div>
								<div class="form-group">
									<label class="input">
										<?php echo $this->lang->line('telephone'); ?>
									</label>
									<input type="tel" name="phonenumber" class="form-control w-100 text-center" placeholder="<?php echo $this->lang->line('telephone'); ?>" value="<?php print $customer->phoneNumber ?>" />
								</div>
								<div class="form-group">
									<label class="input">
										<?php echo $this->lang->line('mail'); ?>
									</label>
									<input type="email" name="email" class="form-control w-100 text-center" placeholder="<?php echo $this->lang->line('mail'); ?>" value="<?php print $customer->email ?>" <?php if ($mode == 'עריכת') print 'disabled="disabled"' ?> />
								</div>
								<div class="form-group">
									<label class="input">
										<?php echo $this->lang->line('address'); ?>
									</label>
									<input type="text" name="address" class="form-control w-100 text-center" placeholder="<?php echo $this->lang->line('address'); ?>" value="<?php print $customer->address ?>" />
								</div>
								<div class="form-group">
									<label class="select">
									</label>
									<select name="city" class="select2">
										<option value=""><?php echo $this->lang->line('city'); ?></option>
										<?php print printCitiesOptions($customer->city); ?>
									</select>
								</div>
							</div>
						</div>
					<?php }; ?>
					<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 mb-3">
						<div class="bg-white p-3 rounded-xl shadow">
							<?php if (isset($permissions['customers']['view_index']['customers-credits']) && $permissions['customers']['view_index']['customers-credits'] == 1) { ?>
								<div class="col col-12">
									<label class="input"><?php echo $this->lang->line('credit'); ?>:
										<i class="icon-append fa fa-dollar"></i>
									</label>
									<input type="number" class="form-control w-100 text-center" onwheel="return false;" name="credits" placeholder="<?php echo $this->lang->line('credit'); ?>" value="<?php print $customer->credits ?>" />
								</div>
							<?php }; ?>
							<?php if (isset($permissions['customers']['view_index']['customers-credits-limit']) && $permissions['customers']['view_index']['customers-credits-limit'] == 1) { ?>
								<div class="col col-12">
									<!-- <label class="label"><?php echo $this->lang->line('limit_credit'); ?></label> -->
									<label class="input">
										<i class="icon-append fa fa-dollar"></i>
									</label>
									<input type="number" class="form-control w-100 text-center" readonly="readonly" onwheel="return false;" name="creditsLimit" placeholder="<?php echo $this->lang->line('limit_credit'); ?>" value="<?php print $customer->creditsLimit ?>" />
								</div>
							<?php }; ?>
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 d-flex justify-content-center" style=" padding-top: 25px; ">
								<div class="btn-group mx-auto" role="group" aria-label="Basic example">
									<?php if (isset($permissions['customers']['view_index']['customers-creditsRentPaid-limit-plus']) && $permissions['customers']['view_index']['customers-creditsRentPaid-limit-plus'] == 1) { ?>
										<button type="button" class="editOblego  btn btn-sm btn-success" rel="credit" rel-credit="creditsLimit"><i class="fa fa-plus"></i></button>
									<?php }; ?>
									<?php if (isset($permissions['customers']['view_index']['customers-creditsRentPaid-limit-minus']) && $permissions['customers']['view_index']['customers-creditsRentPaid-limit-minus'] == 1) { ?>
										<button type="button" class="editOblego  btn btn-sm btn-danger" rel="debit" rel-credit="creditsLimit"><i class="fa fa-minus"></i></button>
									<?php }; ?>
								</div>
							</div>

						</div>
					</div>
					<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
						<div class="bg-white p-3 rounded-xl shadow">
							<?php if (isset($permissions['customers']['view_index']['customers-bank-details']) && $permissions['customers']['view_index']['customers-bank-details'] == 1) { ?>
								<div class="col col-12">
									<label class="select"><?php echo $this->lang->line('bank'); ?></label>
									<select name="bank" class="form-select select2">
										<option value=""><?php echo $this->lang->line('bank'); ?></option>
										<?php foreach ($banks as $bank) { ?>
											<option value="<?php echo $bank->bank_code; ?>" <?php if ($bank->bank_code == $customer->bank) {
																								echo "selected";
																							}; ?>><?php echo $bank->bank_name; ?></option>
										<?php }; ?>
									</select><i></i>
								</div>
								<div class="col col-12">
									<label class="input"><?php echo $this->lang->line('branch'); ?></label>
									<input type="number" class="form-control w-100 text-center" name="branch" placeholder="<?php echo $this->lang->line('branch'); ?>" value="<?php print $customer->branch ?>" />
								</div>
								<div class="col col-12">
									<label class="input">
										<?php echo $this->lang->line('account'); ?></label>
									<input type="number" class="form-control w-100 text-center" name="bank_account" placeholder="<?php echo $this->lang->line('account'); ?>" value="<?php print $customer->bank_account ?>" />
								</div>

							<?php }; ?>
							<?php if (isset($permissions['customers']['view_index']['customers-permissions']) && $permissions['customers']['view_index']['customers-permissions'] == 1) { ?>
								<div class="d-flex flex-column justify-content-between">
									<div>
										<div class="form-switch d-flex justify-content-start mt-3">
											<input class="form-check-input" type="checkbox" id="isActive" name="isActive" <?php if ($customer->isActive == 1 || $customer->isActive == '') print 'checked="checked"'; ?>>
											<label class="form-check-label" for="isActive" style="margin-right: 40px;"><?php echo $this->lang->line('active'); ?></label>
										</div>
									</div>
								</div>
							<?php }; ?>
						</div>
					</div>
				</div>
				<div>
					<div class="card me-auto w-25">
						<?php if (isset($permissions['customers']['edit_index']) && $permissions['customers']['edit_index'] == 1) { ?>
							<?php if ($mode == 'עריכת') : ?>
								<!-- <button type="button" class="btn bg-color-purple txt-color-white pull-right" data-toggle="modal" data-target="#changeUserPasswordModal"><?php echo $this->lang->line('change_password'); ?> </button> -->
								<button type="submit" class="btn btn-primary "><?php echo $this->lang->line('update'); ?></button>
							<?php else : ?>
								<button type="submit" class="btn btn-primary pull-right flaot-right"><?php echo $this->lang->line('save'); ?> </button>
							<?php endif; ?>
						<?php }; ?>
					</div>
				</div>
		</div>
		</form>
	</div>
</div>
</div>

<div class="modal" id="changeUserPasswordModal" tabindex="-1" role="dialog" aria-labelledby="changeUserPasswordModal" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">
					<?php echo $this->lang->line('change_password'); ?>
				</h5>
				<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<form action="" id="changeUserPasswordForm" method="POST" autocomplete="OFF">
					<div class="row">
						<div class="col-lg-6">
							<label class="label"><?php echo $this->lang->line('password'); ?></label>
							<label class="input">
							</label>
							<input type="password" class="form-control text-center" id="newPassword" name="newPassword" value="" autocomplete="OFF" class="form-control" />
						</div>

						<div class="col-lg-6">
							<label class="label"><?php echo $this->lang->line('validtion_password'); ?></label>
							<label class="input">
							</label>
							<input type="password" id="newPassword2" name="newPassword2" value="" autocomplete="OFF" class="form-control text-center" />
						</div>

					</div>
				</form>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
				<button type="button" class="btn btn-primary" id="changeUserPassword" rel="<?php print $customer->adminId; ?>" style=" float: left; "><?php echo $this->lang->line('save'); ?></button>
			</div>
		</div>
	</div>
</div>
<div class="modal" id="removeOblego" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel"><?php print $this->lang->line('remove_from_limit'); ?></h5>
				<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-lg-12">
						<input type="hidden" class="form-control" name="appType" id="appType" />
						<input type="hidden" class="form-control" name="creditType" id="creditType" />
						<input type="number" class="form-control" name="total_to_remove" id="total_to_remove" />
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
				<button type="button" class="btn btn-primary" id="changeNewOblego"><?php echo $this->lang->line('save'); ?></button>

			</div>
		</div>
	</div>
</div>

<script>
	$(document).ready(function() {
		$(document).on('click', '.editOblego', function() {
			var elem = $(this);
			$('#creditType').val(elem.attr("rel"));
			$('#appType').val(elem.attr("rel-credit"));
			$('#removeOblego').modal('show');
		});
		$('#changeNewOblego').on('click', function() {
			if (Number($('#total_to_remove').val()) > 0) {
				var data = {};
				data.customerId = '<?php echo $customer->customerId; ?>',
					data.type = $('#appType').val();
				data.total = $('#total_to_remove').val();
				data.creditType = $('#creditType').val();
				$.post(root + 'admin/customers/removeFromOblego', data, function(d) {
					if (d.result) {
						window.location.reload();
					}
				}, 'json');
			}
		});
		$('#changeUserPassword').on('click', function() {

			var adminId = $(this).attr("rel");
			var password = $('#newPassword').val();
			var password2 = $('#newPassword2').val();
			if (password == password2) {
				$.post(root + 'admin/ajax/newPasswordforUser', {
					'adminId': adminId,
					'password': password,
					'password2': password2
				}, function(d) {
					if (d.result == true) {

						alert("<?php echo $this->lang->line('successfully_updated'); ?>");
						location.reload();
					} else {
						alert("<?php echo $this->lang->line('Error'); ?>");
					}
				}, 'json');
			} else {
				alert("<?php echo $this->lang->line('Incompatible_passwords'); ?>");
				$('#newPassword').parent().addClass("has-error");
				$('#newPassword2').parent().addClass("has-error");
			}

		});
		$('#is_auto_pay_active').on('click', function() {
			if ($(this).prop('checked') == true) {
				$('.auto_payment_divs').show();
			} else {
				$('.auto_payment_divs').hide();
			}
		});
	});
</script>
<?php if ($mode == 'עריכת') : ?>
	<?php if (!empty($LeadsData)) { ?>
		<script>
			var config2 = {
				type: 'bar',
				data: {
					datasets: [{
							data: [
								"<?php echo $LeadsData['2019']['01']; ?>",
								"<?php echo $LeadsData['2019']['02']; ?>",
								"<?php echo $LeadsData['2019']['03']; ?>",
								"<?php echo $LeadsData['2019']['04']; ?>",
								"<?php echo $LeadsData['2019']['05']; ?>",
								"<?php echo $LeadsData['2019']['06']; ?>",
								"<?php echo $LeadsData['2019']['07']; ?>",
								"<?php echo $LeadsData['2019']['08']; ?>",
								"<?php echo $LeadsData['2019']['09']; ?>",
								"<?php echo $LeadsData['2019']['10']; ?>",
								"<?php echo $LeadsData['2019']['11']; ?>",
								"<?php echo $LeadsData['2019']['12']; ?>",
							],
							backgroundColor: [
								'#607D8B',
								'#607D8B',
								'#607D8B',
								'#607D8B',
								'#607D8B',
								'#607D8B',
								'#607D8B',
								'#607D8B',
								'#607D8B',
								'#607D8B',
								'#607D8B',
								'#607D8B'
							],
							label: '2019'
						},
						{
							data: [
								"<?php echo $LeadsData['2020']['01']; ?>",
								"<?php echo $LeadsData['2020']['02']; ?>",
								"<?php echo $LeadsData['2020']['03']; ?>",
								"<?php echo $LeadsData['2020']['04']; ?>",
								"<?php echo $LeadsData['2020']['05']; ?>",
								"<?php echo $LeadsData['2020']['06']; ?>",
								"<?php echo $LeadsData['2020']['07']; ?>",
								"<?php echo $LeadsData['2020']['08']; ?>",
								"<?php echo $LeadsData['2020']['09']; ?>",
								"<?php echo $LeadsData['2020']['10']; ?>",
								"<?php echo $LeadsData['2020']['11']; ?>",
								"<?php echo $LeadsData['2020']['12']; ?>",
							],
							backgroundColor: [
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange,
								window.chartColors.orange
							],
							label: '2020'
						},
						{
							data: [
								"<?php echo $LeadsData['2021']['01']; ?>",
								"<?php echo $LeadsData['2021']['02']; ?>",
								"<?php echo $LeadsData['2021']['03']; ?>",
								"<?php echo $LeadsData['2021']['04']; ?>",
								"<?php echo $LeadsData['2021']['05']; ?>",
								"<?php echo $LeadsData['2021']['06']; ?>",
								"<?php echo $LeadsData['2021']['07']; ?>",
								"<?php echo $LeadsData['2021']['08']; ?>",
								"<?php echo $LeadsData['2021']['09']; ?>",
								"<?php echo $LeadsData['2021']['10']; ?>",
								"<?php echo $LeadsData['2021']['11']; ?>",
								"<?php echo $LeadsData['2021']['12']; ?>",
							],
							backgroundColor: [
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue,
								window.chartColors.blue
							],
							label: '2021'
						}
					],
					labels: [
						'1',
						'2',
						'3',
						'4',
						'5',
						'6',
						'7',
						'8',
						'9',
						'10',
						'11',
						'12'
					]
				},
				options: {
					responsive: true
				}
			};

			window.onload = function() {
				var ctx2 = document.getElementById('chart-area').getContext('2d');
				window.myLine = new Chart(ctx2, config2);
			};
			var colorNames = Object.keys(window.chartColors);
		</script>
	<?php }; ?>
<?php endif; ?>