<?php
if (
    !isset($permissions['finance']['view_index'])
    || isset($permissions['finance']['view_index'])
    && $permissions['finance']['view_index'] == 0
) redirect('admin/dashboard');
?>

<script src="https://www.chartjs.org/dist/2.9.3/Chart.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/utils.js"></script>

<!-- MAIN PANEL -->
<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" style=" padding-top: 0px; ">

        <div class="row">


            <div class="col col-lg-8 table-responsive">
                <h2><?php echo $this->lang->line('page_financial'); ?></h2>
                <hr />
                <br />
                <div class="row">
                    <div class="col col-lg-12 all_boxes_wrap">
                        <div class="btn-group" role="group" aria-label="Category">
                            <button type="button" class="btn btn-success filter_cat" rel="all">
                                <?php echo $this->lang->line('all_cashboxes'); ?>
                            </button>
                            <?php foreach ($boxes_category as $cat) { ?>
                                <button type="button" class="btn btn-info filter_cat" rel="<?php echo $cat->category; ?>">
                                    <?php if ($cat->category == 'bank') { ?>
                                        <?php echo $this->lang->line('all_banks'); ?>
                                    <?php }; ?>
                                    <?php if ($cat->category == 'visa') { ?>
                                        <?php echo $this->lang->line('credit_clearing'); ?>
                                    <?php }; ?>

                                </button>
                            <?php }; ?>
                        </div>
                        <br />
                        <br />
                    </div>
                    <?php foreach ($sums as $sum) { ?>
                        <div class="col col-lg-3 col-sm-12 boxes mb-2" rel="<?php echo $payment_boxes[$sum['id']]->category; ?>">
                            <?php if ($payment_boxes[$sum['id']]->category == 'bank') { ?>
                                <?php $bg = '#F44336'; ?>
                            <?php } else if ($payment_boxes[$sum['id']]->category == 'visa') { ?>
                                <?php $bg = '#4CAF50'; ?>
                            <?php } else if ($payment_boxes[$sum['id']]->category == 'agent') { ?>
                                <?php $bg = '#009688'; ?>
                            <?php } else { ?>
                                <?php $bg = 'grey'; ?>
                            <?php }; ?>
                            <a href="<?php echo site_url(); ?>admin/invoices/boxes/<?php echo $sum['id']; ?>" target="_blank" class="btn-link">
                                <div class="p-3" style="background-color: <?php echo $bg; ?>;">
                                    <div class="img_box">
                                        <img src="<?php echo site_url(); ?>assets/img/<?php echo $payment_boxes[$sum['id']]->logo; ?>">
                                    </div>
                                    <p class="font-lg txt-color-white">
                                        <i class="fa fa-dollar fa-md" style="margin: 3% 0 0 5%;"></i>
                                        <?php print number_format($sum['sum']); ?>
                                    </p>
                                    <p class="font-lg txt-color-white"> <?php print $sum['name']; ?></p>
                                </div>
                            </a>
                        </div>
                    <?php }; ?>
                </div>

                <div class="row">
                    <div class="col-sm-12 col-md-12 col-lg-12">
                        <div class="jarviswidget jarviswidget-color-orange" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-editbutton="false" data-widget-togglebutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false" data-widget-custombutton="false" data-widget-collapsed="false" data-widget-sortable="false">
                            <header>
                                <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
                                <span class="widget-icon"> <i class="fa fa-star"></i> </span>
                                <h2>
                                    <?php echo $this->lang->line('general_status'); ?>
                                </h2>

                            </header>
                            <div>
                                <div class="jarviswidget-editbox"></div>
                                <div class="widget-body no-padding">
                                    <canvas id="chart-area"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col col-lg-4 col-md-12 col-sm-12">
                <h2><?php echo $this->lang->line('actions'); ?></h2>
                <hr />
                <br />
                <div class="">
                
                    <div class="list-group">
                        <a href="<?php echo site_url(); ?>admin/invoices" target="_blank" title="<?php echo $this->lang->line('invoices'); ?>" class="list-group-item list-group-item-action "><?php echo $this->lang->line('invoices'); ?></a>
                        <a href="<?php echo site_url(); ?>admin/invoices/payments" target="_blank" title="<?php echo $this->lang->line('receipts'); ?>" class="list-group-item list-group-item-action "><?php echo $this->lang->line('receipts'); ?></a>
                        <a href="<?php echo site_url(); ?>admin/suppliers" title="<?php echo $this->lang->line('suppliers'); ?>" class="list-group-item list-group-item-action ">
                            <?php echo $this->lang->line('suppliers'); ?>
                        </a>
                        <a href="<?php echo site_url(); ?>admin/invoices/manageBoxes" title="<?php echo $this->lang->line('fund_management'); ?>" class="list-group-item list-group-item-action ">
                            <?php echo $this->lang->line('fund_management'); ?>
                        </a>
                        <hr />
                        <a href="<?php echo site_url(); ?>admin/invoices/create" title="<?php echo $this->lang->line('new_invoice_receipt'); ?>" target="_blank" class="list-group-item list-group-item-action ">
                            <i class="fa fa-plus"></i>
                            <?php echo $this->lang->line('new_invoice_receipt'); ?>
                        </a>
                        <a href="<?php echo site_url(); ?>admin/invoices/createInv" title="<?php echo $this->lang->line('invoicing_tax_new'); ?>" target="_blank" class="list-group-item list-group-item-action ">
                            <i class="fa fa-plus"></i>
                            <?php echo $this->lang->line('invoicing_tax_new'); ?>
                        </a>

                        <a href="#0" class="list-group-item list-group-item-action" data-bs-toggle="modal" data-bs-target="#createPaymentModal">
                            <i class="fa fa-plus"></i>
                            <?php echo $this->lang->line('Production_receipt'); ?>
                        </a>

                        <a href="#0" class="list-group-item list-group-item-action" data-bs-toggle="modal" data-bs-target="#createSupplierInvoice">
                            <i class="fa fa-plus"></i>
                            <?php echo $this->lang->line('invoicing__supplier'); ?>


                        </a>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- END MAIN CONTENT -->

</div>

<div class="modal" id="createPaymentModal" tabindex="-1" role="dialog" aria-labelledby="createPaymentModal" aria-hidden="true" title="<?php echo $this->lang->line('Production_receipt'); ?>">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createPaymentModalTitle">
                    <?php echo $this->lang->line('Production_receipt'); ?>
                </h5>
                <button type="button" class="btn close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="no-action" method="POST" class="" id="payment_data" autocomplete="OFF">
                    <div class="row">
                        <div class="col col-lg-12 form-group">
                            <label for="payment_box"><?php echo $this->lang->line('send_to'); ?>: </label>
                            <select name="customerId" class="select2" id="customerId" style="width:100%;">
                                <option value=""><?php echo $this->lang->line('select2'); ?></option>
                                <option value="temp_customer"><?php echo $this->lang->line('customer_Casual'); ?></option>
                                <optgroup class="companies_list_from" label="<?php echo $this->lang->line('customers'); ?>">
                                    <?php foreach ($customers as $customer) { ?>
                                        <option rel="customer" value="<?php echo $customer->customerId; ?>"><?php echo $customer->customerName; ?></option>
                                    <?php }; ?>
                                </optgroup>
                                <optgroup class="companies_list_from" label="<?php echo $this->lang->line('customers_Casuals'); ?>">
                                    <?php foreach ($temp_clients as $temp_client) { ?>
                                        <option rel="temp_customer" value="<?php echo $temp_client->detail_id; ?>"><?php echo $temp_client->customer_name; ?> - <?php echo $temp_client->customer_id_number; ?></option>
                                    <?php }; ?>
                                </optgroup>
                            </select>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 temp_customer form-group">
                            <label for="customer_name"><?php echo $this->lang->line('customer_name'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="customer_name" class="form-control" />
                            </label>
                            <br />
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 temp_customer form-group">
                            <label for="customer_email"><?php echo $this->lang->line('email'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="customer_email" class="form-control" />
                            </label>
                            <br />
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 temp_customer form-group">
                            <label for="customer_id_number"><?php echo $this->lang->line('ID'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="customer_id_number" class="form-control" />
                            </label>
                            <br />
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 temp_customer form-group">
                            <label for="customer_phone"><?php echo $this->lang->line('telephone'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="customer_phone" class="form-control" />
                            </label>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 temp_customer form-group">
                            <label for="customer_file_no"><?php echo $this->lang->line('customer_num'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="customer_file_no" class="form-control" />
                            </label>
                            <br />
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 temp_customer form-group">
                            <label for="customer_4_digits"><?php echo $this->lang->line('Last_4_digits'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="customer_4_digits" class="form-control" />
                            </label>
                            <br />
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 form-group">
                            <label for="payment_box"><?php echo $this->lang->line('cashbox'); ?></label>
                            <label class="select">
                                <select name="payment_box" class="form-control">
                                    <?php foreach ($payment_boxes as $payment_box) { ?>
                                        <option value="<?php echo $payment_box->box_id; ?>"><?php echo $payment_box->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 form-group">
                            <label for="payment_type"><?php echo $this->lang->line('payment_method'); ?></label>
                            <label class="select">
                                <select name="payment_type" class="form-control" id="payment_type">
                                    <option value=""><?php echo $this->lang->line('select2'); ?></option>
                                    <?php foreach ($payment_types as $payment_type) { ?>
                                        <option value="<?php echo $payment_type->type_id; ?>"><?php echo $payment_type->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 form-group">
                            <label for="payment_date"><?php echo $this->lang->line('date'); ?></label>
                            <label class="input">
                                <input type="text" value="<?php echo date('d-m-Y'); ?>" name="payment_date" class="form-control datepicker payment_date" />
                            </label>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 visa_details form-group">
                            <label for="bank_visa"><?php echo $this->lang->line('bank_visa'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="bank_visa" class="form-control" />
                            </label>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 visa_details form-group">
                            <label for="branch_digits"><?php echo $this->lang->line('Branch_digits'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="branch_digits" class="form-control" />
                            </label>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 visa_details form-group">
                            <label for="account_card"><?php echo $this->lang->line('invoice_validity'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="account_card" class="form-control" />
                            </label>
                            <br />
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 visa_details form-group">
                            <label for="reference_id"><?php echo $this->lang->line('reference_id_num'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="reference_id" class="form-control" />
                            </label>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12 form-group">
                            <label for="total_payment"><?php echo $this->lang->line('sum'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="total_payment" class="form-control" />
                            </label>
                            <br />
                        </div>
                        <div class="col col-lg-12 col-sm-12 col-md-12 form-group">
                            <label for="notes2"><?php echo $this->lang->line('note'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="notes2" class="form-control" />
                            </label>
                            <br />
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
                <button type="button" class="btn btn-primary" id="savePaymentDetails" style="float:left;"><?php echo $this->lang->line('save'); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="createSupplierInvoice" tabindex="-1" role="dialog" aria-labelledby="createSupplierInvoice" aria-hidden="true" title="<?php echo $this->lang->line('Production_receipt'); ?>">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createPaymentModalTitle">
                    <?php echo $this->lang->line('Production_receipt'); ?>
                </h5>
                <button type="button" class="btn close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="no-action" method="POST" class="smart-form" id="SupplierInvoiceForm" autocomplete="OFF">
                    <div class="row">
                        <div class="col col-lg-12">
                            <label for="payment_box"><?php echo $this->lang->line('send_to'); ?>: </label>
                            <select name="supplier_id" class="select2" id="supplier_id">
                                <option value="" selected><?php echo $this->lang->line('select2'); ?></option>
                                <?php foreach ($suppliers as $supplier) { ?>
                                    <option value="<?php echo $supplier->supplier_id; ?>"><?php echo $supplier->name; ?></option>
                                <?php }; ?>
                            </select>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="payment_box"><?php echo $this->lang->line('cashbox'); ?></label>
                            <label class="select">
                                <select name="payment_box" class="form-control">
                                    <?php foreach ($payment_boxes as $payment_box) { ?>
                                        <option value="<?php echo $payment_box->box_id; ?>"><?php echo $payment_box->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                        </div>
                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="payment_type"><?php echo $this->lang->line('payment_method'); ?></label>
                            <label class="select">
                                <select name="payment_type" class="form-control">
                                    <option value=""><?php echo $this->lang->line('select2'); ?></option>
                                    <?php foreach ($payment_types as $payment_type) { ?>
                                        <option value="<?php echo $payment_type->type_id; ?>"><?php echo $payment_type->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                            <br />
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="invoice_number"><?php echo $this->lang->line('invoices_num'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="invoice_number" class="form-control" />
                            </label>
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="invoice_date"><?php echo $this->lang->line('date'); ?></label>
                            <label class="input">
                                <input type="text" value="<?php echo date('d-m-Y'); ?>" name="invoice_date" class="form-control datepicker invoice_date" />
                            </label>
                        </div>

                        <div class="col col-lg-12 col-sm-12 col-md-12">
                            <label for="invoice_for"><?php echo $this->lang->line('for'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="invoice_for" class="form-control" />
                            </label>
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="invoice_total"><?php echo $this->lang->line('sum'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="invoice_total" class="form-control" />
                            </label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
                <button type="button" class="btn btn-primary" id="saveSupplierInvoiceData" style="float:left;"><?php echo $this->lang->line('save'); ?></button>
            </div>
        </div>
    </div>
</div>

<style>
    .all_boxes_wrap .well {
        height: auto;
        max-height: 160px;
    }

    .img_box img {
        max-width: 100%;
        max-height: 40px;
        width: auto;
        height: 30px;
    }

    .img_box {
        width: 100%;
        text-align: center;
        background: white;
        border-radius: 25px;
        margin-bottom: 15px;
        padding: 5px;
    }

    #checkbox_wrap input[type="checkbox"] {
        display: block !important;
        position: relative !important;
        right: 0px;
        left: 0px;
    }

    .visa_details {
        display: none;
    }

    .temp_customer {
        display: none;
    }

    ul.select2-result-sub {
        padding-right: 5px !important;
    }

    .select2-result-sub li {
        border-right: 4px solid #dadada;
    }

    .select2-results li.select2-result-with-children>.select2-result-label {
        font-weight: bold;
        background: #F44336;
        color: white;
    }

    .remove_this_item,
    .remove_this_payment {
        position: absolute;
        right: 0px;
        margin-top: 15px;
    }

    .remove_this_item:active,
    .remove_this_payment:active {
        position: absolute;
        top: auto !important;
        left: auto !important;
        right: 0px !important;
    }
</style>

<script type="text/javascript">
    $(document).ready(function() {
        $('#savePaymentDetails').on('click', function() {

            var data = $('#payment_data').serializeArray();

            $.post(root + 'admin/invoices/addPayment', data, function(d) {

                if (d.result == true) {
                    alert("<?php echo $this->lang->line('Done'); ?>!");
                    window.location.href = "https://www.callup2.co/admin/invoices/viewPayment/" + d.payment;
                } else {
                    alert("<?php echo $this->lang->line('Error'); ?>!");
                }

            }, 'json');
        });
        $('#saveSupplierInvoiceData').on('click', function() {

            var data = $('#SupplierInvoiceForm').serializeArray();

            $.post(root + 'admin/invoices/insertSupplierInvoice', data, function(d) {

                if (d.result == true) {
                    alert("<?php echo $this->lang->line('Done'); ?>!");
                    location.reload();
                } else {
                    alert("<?php echo $this->lang->line('Error'); ?>!");
                }

            }, 'json');
        });
        $('.filter_cat').on('click', function() {
            var cat = $(this).attr("rel");
            if (cat == 'all') {
                $('.boxes').fadeIn();
            } else {
                $('.boxes').hide();
                $('.boxes[rel="' + cat + '"]').fadeIn();
            }
        });
        $('.datepicker').datepicker({
            dateFormat: "dd-mm-yy",
            isRTL: true,
            prevText: '<i class="fa fa-chevron-left"></i>',
            nextText: '<i class="fa fa-chevron-right"></i>',
        });
        $('#customerId').on('change', function() {
            var data = {};
            data.rel = $(this).find(':selected').attr('rel');
            data.customerId = $(this).find(':selected').val();
            var text_invoice = '<?php echo $this->lang->line('Invoice_number'); ?>: ';
            var text_total = '<?php echo $this->lang->line('sum'); ?>: ';
            $('#checkbox_wrap').html("");
            if ($(this).find(':selected').val() == 'temp_customer') {
                $('.temp_customer').show();
            } else {
                $('.temp_customer').hide();
            }
        });
        $('#payment_type').on('change', function() {
            if ($(this).val() == 1 || $(this).val() == 2 || $(this).val() == 4) {
                $('.visa_details').show();
            } else {
                $('.visa_details').hide();
            }
        });
    });
</script>
<script>
    var config = {
        type: 'doughnut',
        data: {
            datasets: [{
                data: [
                    <?php foreach ($sums as $sum) { ?> "<?php echo $sum['sum']; ?>",
                    <?php }; ?>
                ],
                backgroundColor: [
                    '#72206a',
                    '#cd0100',
                    '#2f968c',
                    '#ed1b23',
                    '#f26622',
                    '#d21e5f',
                    '#8a6d3b',
                    '#f26622',
                    '#d21e5f',
                    '#8a6d3b',
                    '#ed1b23',
                    '#f26622',
                    '#d21e5f'
                ],
                label: 'Dataset 1'
            }],
            labels: [
                <?php foreach ($sums as $sum) { ?> "<?php echo $sum['name']; ?>",
                <?php }; ?>
            ]
        },
        options: {
            responsive: true,
        }
    };

    window.onload = function() {
        var ctx = document.getElementById('chart-area').getContext('2d');
        window.myPie = new Chart(ctx, config);
    };

    var colorNames = Object.keys(window.chartColors);
</script>