<?php

class users_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }
    
    function getUsers($isActive = true) {
        $this->db->select('u.*, ut.title');
        $this->db->from('users u');
        $this->db->join('user_types ut', 'u.typeId = ut.utId', 'left');
        $query = $this->db->get();
        
		return $query->result();
	}
    
    function getUsersByOwner($isActive = true, $ownerId = 0) {
        $this->db->select('u.*, ut.title');
        $this->db->from('users u');
        $this->db->join('user_types ut', 'u.typeId = ut.utId', 'left');
        $this->db->where('u.adminId', $ownerId);
        $query = $this->db->get();
        
		return $query->result();
	}

    function getUserById($userId, $isActive = true) {
        $this->db->select('*');
        $this->db->from('users');
        $this->db->where('userId', $userId);
        //$this->db->where('IsActive', $isActive);
        $query = $this->db->get();
        
		return $query->result();
	}
     
    function getUsernamesByCustomerId($customerId) {
        $this->db->select('u.userId, u.firstname, u.lastname');
        $this->db->from('users u');
        $this->db->where('u.adminId', $customerId);
        $this->db->where('u.isActive', '1');
        $this->db->order_by('u.firstname', 'ASC');
        $query = $this->db->get();
        
		return $query->result();
	}


    function insertUser($data) {
		$result = $this->db->insert('users', $data);
		if ($result) {
			return $this->db->insert_id();
		} else {
			return false;
		}
	}
    
    function updateUserById($data, $userId) {
		$this->db->where('userId', $userId);
        return $this->db->update('users', $data);
	}
    
    function getLatestNews($limit = NULL, $isActive = true) {
        $this->db->select('*');
        $this->db->from('news');
        $this->db->order_by('LastUpdate', 'desc');
        $this->db->where('IsActive', $isActive);
        if($limit != NULL) {
            $this->db->limit($limit);
        }
        $query = $this->db->get();
        
		return $query->result();
        
    }
    
 }