<link href="https://www.callup2.co/assets/css/print.css" rel="stylesheet" media="print" />
<style>
    body {
        background: rgb(204,204,204); 
    }
    page {
        background: white;
        display: block;
        margin: 0 auto;
        margin-bottom: 0.5cm;
        box-shadow: 0 0 0.5cm rgba(0,0,0,0.5);
    }
    page[size="A4"] {  
        width: 21cm;
        height: 29.7cm;
        padding:25px;
        padding-top:20px;
    }
    .col{
        text-align:center;
    }
    
    table.table.table-condensed tr td:nth-child(2) {
        font-weight: bold;
    }
    
    table.table.table-condensed td {
        border-top: 0px !Important;
        padding: 0px;
    }
    
    #invoice_table {
        text-align: right;
    }
    
    #invoice_table tfoot td:nth-child(2) {
        text-align: left;
        font-weight: bold;
    }
    
    #invoice_table tfoot td:nth-child(3) {
        font-weight: bold;
    }
    
    #invoice_table tfoot tr:nth-child(1) td {
        border-width: 2px !important;
        border-color: #b5b5b5;
    }
    
    #invoice_table tfoot tr:nth-last-child(1) td:nth-child(3),
    #invoice_table tfoot tr:nth-last-child(1) td:nth-child(2) {
        background: #f1f1f1;
    }
    
    #invoice_table, #payment_table{
        border: 1px solid #dedede;
        text-align: right !important;
    }
    
    #payment_table tfoot {
        font-weight: bold;
    }
    
    #payment_table tfoot tr td:nth-child(3),
    #payment_table tfoot tr td:nth-child(2) {
        background: #f1f1f1;
    }

</style>

<div id="main" role="main">
	<div id="content">
	    <page size="A4">
	        <div class="row">
	            <div class="col col-lg-12 col-md-12 col-sm-12">
	                <h2>
                    <!-- <?php echo $this->lang->line('receipt_number'); ?>: 
	                    <strong><?php echo $payments->receipt_number; ?></strong> -->
	                </h2>
	            </div>
	            <div class="col-lg-9 col-md-9 col-sm-9" id="customer_details">
	                <table class="table table-condensed">
	                    <tbody>
                                <tr>
    	                            <td>
                                    <?php echo $this->lang->line('send_to'); ?>
    	                                <?php echo $customer->invName; ?>
    	                            </td>
    	                        </tr>
    	                        <tr>
    	                            <td><?php echo $customer->phoneNumber; ?></td>
    	                        </tr>
    	                        <tr>
    	                            <td><?php echo $customer->invID; ?></td>
    	                        </tr>
    	                        <tr>
    	                            <td><?php echo $customer->invEmail; ?></td>
    	                        </tr>
	                    </tbody>
	                </table>
	            </div>
	            <div class="col-lg-3 col-md-3 col-sm-3" id="main_invoice_details">
	                <table class="table table-condensed">
	                    <tbody>
	                        <tr>
	                            <td colspan="2"><?php echo $this->lang->line('copy_source'); ?></td>
	                        </tr>
	                        <tr>
	                            <td><?php echo $this->lang->line('date'); ?></td>
	                            <td><?php echo date('d/m/Y', strtotime($payments->payment_date)); ?></td>
	                        </tr>
                                <tr>
    	                            <td><?php echo $this->lang->line('customer_number'); ?></td>
    	                            <td><?php echo $customer->customerId; ?></td>
    	                        </tr>
    	                        <tr>
    	                            <td><?php echo $this->lang->line('number_deals'); ?></td>
    	                            <td><?php echo $customer->invID; ?></td>
    	                        </tr>
	                    </tbody>
	                </table>
	            </div>
                <div class="col col-lg-12 col-md-12 col-sm-12" id="payments_details">
                    <br/>
                    <hr/>
	                <table class="table" id="payment_table">
	                    <thead>
                        <th><?php echo $this->lang->line('cashbox'); ?></th>
                        <th><?php echo $this->lang->line('payment_method'); ?></th>
                        <th><?php echo $this->lang->line('date_maturity'); ?></th>
                        <th><?php echo $this->lang->line('bank'); ?></th>
                        <th><?php echo $this->lang->line('branch_4digits'); ?></th>
                        <th><?php echo $this->lang->line('account_validity'); ?></th>
                        <th><?php echo $this->lang->line('reference_id'); ?></th>
                        <th><?php echo $this->lang->line('total'); ?></th>
	                    </thead>
	                    <tbody>
	                        <?php $full_payment_total = 0; ?>
	                        <tr>
	                            <td><?php echo $payment_boxes[$payments->payment_box]->name; ?></td>
	                            <td><?php echo $payment_types[$payments->payment_type]->name; ?></td>
	                            <td><?php echo date('d/m/Y', strtotime($payments->payment_date)); ?></td>
	                            <td><?php echo $payments->bank_visa; ?></td>
	                            <td><?php echo $payments->branch_digits; ?></td>
	                            <td><?php echo $payments->account_card; ?></td>
	                            <td><?php echo $payments->reference_id; ?></td>
	                            <td><?php echo number_format($payments->total, 2); ?></td>
	                        </tr>
	                        <?php $full_payment_total = $full_payment_total + $payments->total; ?>
	                    </tbody>
	                    <tfoot>
	                        <tr>
	                            <td colspan="5"></td>
	                            <td colspan="2"><?php echo $this->lang->line('total_receipt_shekel'); ?></td>
	                            <td><?php echo number_format($full_payment_total, 2); ?></td>
	                        </tr>
	                    </tfoot>
	                </table>
	            </div>
	            <?php if(!empty($all_payed_amount) || !empty($payments->notes2) ){ ?>
    	            <div class="col col-lg-12 col-md-12 col-sm-12" id="payed_details">
    	                <table class="table table-striped table-condensed table-bordered">
    	                    <tbody>
    	                        <?php if(!empty($all_payed_amount)){ ?>
        	                        <?php foreach( $all_payed_amount as $p ){ ?>
        	                            <tr>
        	                                <td>
                                            <?php echo $this->lang->line('Assigned_sum'); ?>:
        	                                    <strong><?php echo $p->total; ?></strong>
        	                                    <?php echo $this->lang->line('to_account_number'); ?>: 
        	                                    <a href="<?php echo site_url(); ?>admin/invoices/view/<?php echo $p->invoice_id; ?>" target="_blank"><strong><?php echo $p->invoice_id; ?></strong></a>
        	                                </td>
        	                            </tr>
        	                        <?php }; ?>
    	                        <?php }; ?>
    	                        <?php if( !empty($payments->notes2) ){ ?>
    	                            <tr>
    	                                <td>
                                        <?php echo $this->lang->line('note'); ?>: 
    	                                    <strong><?php echo $payments->notes2; ?></strong>
	                                    </td>
    	                            </tr>
    	                        <?php }; ?>
    	                    </tbody>
    	                </table>
    	            </div>
	            <?php }; ?>
	        </div>
	    </page>
    </div>
</div>

<div class="modal fade" id="add_payment_to_invoice_modal" tabindex="-1" role="dialog" aria-labelledby="add_payment_to_invoice_modal" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="add_payment_to_invoice">
        <?php echo $this->lang->line('Assigned_receipt'); ?>
            
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="table_wrap">
                    <thead>
                        <th>#</th>
                        <th><?php echo $this->lang->line('sum'); ?></th>
                        <th><?php echo $this->lang->line('paid'); ?></th>
                        <th><?php echo $this->lang->line('balance'); ?></th>
                        <th><?php echo $this->lang->line('sum_Assigned'); ?></th>
                        <th></th>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
        <button type="button" class="btn btn-primary" id="saveSupplierInvoiceData" style="float:left;"><?php echo $this->lang->line('save'); ?></button>
      </div>
    </div>
  </div>
</div>
<?php if(isset($customer->customerId)){ ?>
    <input type="hidden" value="<?php echo $customer->customerId; ?>" rel="customer" id="customer_type"/>
<?php }else if(isset($customer->detail_id)){ ?>
    <input type="hidden" value="<?php echo $customer->detail_id; ?>" rel="temp_customer" id="customer_type"/>
<?php }; ?>

<script type="text/javascript">
    
    $(document).ready(function(){
        var total           = Number("<?php echo number_format($payments->total, 2); ?>");
        var current_payed   = Number("<?php echo number_format($payed_amount->total, 2); ?>");
        
        $('#add_payment_to_invoice').on('click', function(){
            if( current_payed >= total ){
                alert("<?php echo $this->lang->line('amount_already_belongs'); ?>!");
            }else{
                var data        = {};
                data.rel        = $('#customer_type').attr("rel");
                data.customerId = $('#customer_type').val();
                $('#table_wrap tbody').html("");
                $.post(root + 'admin/invoices/getOpenInvoices', data , function(d) {
                    if(d.result == true){
                        $('#add_payment_to_invoice_modal').modal('show');
                        $.each(d.data, function (index, value) {
                            $('#table_wrap tbody').append('<tr><td>'+value.invoice_id+'</td> <td>'+value.total+'</td> <td>'+value.payed+'</td> <td>'+value.balance+'</td> <td><input type="number" class="new_value form-control" value="" /></td> <td><a href="#0" class="edit_payed btn btn-success btn-circle" rel-invoice="'+value.invoice_id+'"><i class="fa fa-check"></i></a></td></tr>');
                        });
                    }else{
                        alert("<?php echo $this->lang->line('Error'); ?>");
                    }
                }, 'json');
            }
        });
        
        $(document).on('click', '.edit_payed', function(){
            var data        = {};
            data.invoice_id = $(this).attr("rel-invoice");
            data.total      = Number($(this).parent().parent().find('input.new_value').val());
            data.payment_id = '<?php echo $payments->payment_id; ?>';
            
            if( data.total <= total ){
                $.post(root + 'admin/invoices/ConnectInvoiceAndPayment', data , function(d) {
                    if(d.result == true){
                        alert("<?php echo $this->lang->line('Done'); ?>!");
                        total -= data.total;
                    }else{
                        alert("<?php echo $this->lang->line('Error'); ?>");
                    }
                }, 'json');
            }else{
                alert("<?php echo $this->lang->line('equal_amount'); ?>!");
            }
        });
         
    });
    
</script>