        <!-- MAIN PANEL -->
        <div id="main" role="main">

            <!-- MAIN CONTENT -->
            <div id="content">

                <div class="row">
                    <div class="col-xs-12 col-sm-7 col-md-7 col-lg-8">
                        <h1 class="page-title txt-color-blueDark">
                            <i class="fa fa-group fa-fw "></i>
                            <?php echo $this->lang->line('customers'); ?>
                            <span>>
                                <?php echo $this->lang->line('closing_account_date'); ?><?php print date('d/m/Y', strtotime($invoice->creationDate)); ?>
                            </span>
                        </h1>
                    </div>
                    <div class="col-xs-12 col-sm-3 col-md-3 col-lg-4">
                        <a class="btn btn-success header-btn pull-right" href="<?php print site_url(); ?>admin/customers/customerPaymentsSum/<?php print $customer->customerId ?>" style="margin-right: 10px;"><i class="fa fa-dollar"></i> <?php echo $this->lang->line('payments'); ?></a>
                        <a class="btn btn-warning header-btn pull-right" href="<?php print site_url(); ?>admin/customers/customerForm/<?php print $customer->customerId ?>" style="margin-right: 10px;"><i class="fa fa-edit"></i> <?php echo $this->lang->line('details_of_customer'); ?></a>
                        <form id="smart-form-register" class="smart-form pull-right" style="width: 200px;">
                            <fieldset class="no-padding">
                                <section>
                                    <label class="select">
                                        <select class="input-md header-btn select2" name="customerId" onchange="window.location = root + 'admin/customers/customerPaymentsSum/' + $(this).val();">
                                            <?php foreach ($customers as $c) : ?>
                                                <option value="<?php print $c->customerId; ?>" <?php if ($c->customerId == $customer->customerId) print 'selected="selected"'; ?>><?php print $c->customerName; ?></option>
                                            <?php $c = null;
                                            endforeach; ?>
                                        </select> </label>
                                </section>
                            </fieldset>
                        </form>
                    </div>

                </div>

                <?php if ($this->session->flashdata('flashMsgType') == 'Success') : ?>
                    <div class="alert alert-success fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-check"></i>
                        <strong><?php print $this->session->flashdata('flashMsgType') ?></strong> <?php print $this->session->flashdata('flashMsg') ?>
                    </div>
                <?php elseif ($this->session->flashdata('flashMsgType') == 'Error') : ?>
                    <div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>
                        <strong><?php print $this->session->flashdata('flashMsgType') ?></strong> <?php print $this->session->flashdata('flashMsg') ?>
                    </div>
                <?php endif; ?>

                <!-- widget grid -->
                <section id="widget-grid" class="">

                    <!-- row -->
                    <div class="row">

                        <!-- NEW WIDGET START -->
                        <article class="col-xs-12 col-sm-12 col-md-9 col-lg-9">

                            <!-- Widget ID (each widget will need unique ID)-->
                            <div class="jarviswidget jarviswidget-color-darken" id="wid-id-0" data-widget-editbutton="false" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-editbutton="false" data-widget-togglebutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false">
                                <!-- widget options:
						usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false">
		
						data-widget-colorbutton="false"
						data-widget-editbutton="false"
						data-widget-togglebutton="false"
						data-widget-deletebutton="false"
						data-widget-fullscreenbutton="false"
						data-widget-custombutton="false"
						data-widget-collapsed="true"
						data-widget-sortable="false"
		
						-->
                                <header>
                                    <span class="widget-icon"> <i class="fa fa-arrow-circle-right"></i> </span>
                                    <h2><?php echo $this->lang->line('payments'); ?> </h2>

                                </header>

                                <!-- widget div-->
                                <div>

                                    <!-- widget edit box -->
                                    <div class="jarviswidget-editbox">
                                        <!-- This area used as dropdown edit box -->

                                    </div>
                                    <!-- end widget edit box -->

                                    <!-- widget content -->
                                    <div class="widget-body no-padding">

                                        <div class="widget-body-toolbar">

                                        </div>

                                        <table id="" class="table table-striped table-hover smart-form">
                                            <thead>
                                                <th>&nbsp;</th>
                                                <th>&nbsp;</th>
                                                <th><?php echo $this->lang->line('number_subscribers'); ?></th>
                                                <th><?php echo $this->lang->line('total'); ?></th>
                                                <th><?php echo $this->lang->line('note'); ?></th>
                                                <th class="text-center"><?php echo $this->lang->line('paid'); ?></th>
                                                <th><?php echo $this->lang->line('date'); ?></th>
                                                <th></th>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td colspan="3"><?php echo $this->lang->line('total'); ?></td>
                                                    <td><?php print number_format($sum, 2); ?> ₪</td>
                                                    <td colspan="5"></td>
                                                </tr>
                                                <?php foreach ($payments as $p) : ?>
                                                    <tr rel="<?php print $p->paymentId; ?>">
                                                        <td>
                                                            <label class="checkbox" style="margin-left: 0;">
                                                                <input class="leadCB" type="checkbox" name="selectedLeads[]" value="<?php print $p->paymentId; ?>" />
                                                                <i></i>
                                                            </label>
                                                        </td>
                                                        <td><?php print $p->title; ?></td>
                                                        <td class="text-center">
                                                            <?php if ($p->qty == 1) : ?>
                                                                <a class="btn btn-xs btn-info" style="" href="<?php print site_url(); ?>admin/leads/viewLead/<?php print $p->leadId; ?>">
                                                                    <?php print getLeadPhone($p->leadId); ?>
                                                                </a>
                                                            <?php elseif ($p->qty > 1) : ?>
                                                                <a class="btn btn-xs btn-info" style="" onclick="javascript: showPaymentLeads(<?php print $p->paymentId; ?>);">
                                                                    <?php print $p->qty; ?>
                                                                </a>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td><span style="direction: ltr;"><?php print number_format($p->total, 2); ?></span> ₪</td>
                                                        <td><?php print $p->comment; ?> <i class="fa fa-edit editCommentBtn"></i></td>
                                                        <td class="text-center paidTd_<?php print $p->paymentId; ?>">
                                                            <?php if ($p->isPaid) : ?>
                                                                <span class="label label-success status"><?php echo $this->lang->line('paid'); ?></span>
                                                            <?php else : ?>
                                                                <span class="label label-danger status"><?php echo $this->lang->line('not_paid'); ?></span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td><?php print date('d/m/Y', strtotime($p->cpDate)); ?></td>
                                                        <td class="text-center">
                                                            <?php if (!$p->isPaid) : ?>
                                                                <a href="javascript: setCpPaid(<?php print $p->paymentId; ?>);" class="btn btn-success btn-xs" title="<?php echo $this->lang->line('cursor_as_paid'); ?>"><i class="fa fa-check"></i></a>
                                                            <?php endif; ?>
                                                            <a href="javascript: delLp(<?php print $p->paymentId; ?>);" class="btn btn-danger btn-xs" title="<?php echo $this->lang->line('payment_deletion'); ?>"><i class="fa fa-trash-o"></i></a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <td colspan="3"><?php echo $this->lang->line('total'); ?></td>
                                                    <td><?php print number_format($sum, 2); ?> ₪</td>
                                                    <td colspan="5"></td>
                                                </tr>
                                            </tfoot>
                                        </table>

                                    </div>
                                    <!-- end widget content -->

                                </div>
                                <!-- end widget div -->

                            </div>
                            <!-- end widget -->

                        </article>
                        <!-- WIDGET END -->

                        <!-- NEW WIDGET START -->
                        <article class="col-xs-12 col-sm-12 col-md-3 col-lg-3">

                            <div class="well well-light">

                                <div class="">

                                    <p class="font-lg">
                                    <?php echo $this->lang->line('closing_account_date'); ?>:<br />
                                        <?php print date('d/m/Y', strtotime($invoice->creationDate)); ?><br /><br />
                                        <?php echo $this->lang->line('total'); ?>: <?php print number_format($invoice->total, 2); ?> ₪
                                    </p>

                                    <?php /*
                            <p class="font-lg">
                            <?php print $cntPay+$cntPayCredit; ?> מנויים לחיוב
                            </p>
                            
                            <p class="font-lg">
                            סה"כ תשלומים: <?php print number_format($total,2); ?> ₪
                            </p>
                            
                            <p class="font-lg">
                            סה"כ בקרדיט: <?php print number_format($credit,2); ?> ₪
                            </p>
                            */ ?>
                                </div>

                            </div>

                            <!-- Widget ID (each widget will need unique ID)-->
                            <div class="jarviswidget jarviswidget-color-purple" id="wid-id-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-editbutton="false" data-widget-togglebutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false" data-widget-custombutton="false" data-widget-sortable="false">

                                <header>
                                    <span class="widget-icon"> <i class="fa fa-lg fa-wrench"></i> </span>
                                    <h2><?php echo $this->lang->line('actions'); ?> </h2>

                                </header>

                                <!-- widget div-->
                                <div>

                                    <!-- widget edit box -->
                                    <div class="jarviswidget-editbox">
                                        <!-- This area used as dropdown edit box -->

                                    </div>
                                    <!-- end widget edit box -->
                                    
                                    <!-- widget content --> 
                                    <div class="widget-body">
                                        <a class="btn btn-info btn-block" id="doLeadsPaymentsBtn"><i class="fa fa-plus"></i> <?php echo $this->lang->line('added_credit_movments'); ?> </button>
                                            <a class="btn btn-success btn-block" onclick="exportCustomerPayments();"><i class="fa fa-arrow-down"></i> <?php echo $this->lang->line('payments_export'); ?>> </button>
                                                <a class="btn btn-default btn-block selectAllCB"><?php echo $this->lang->line('cursor_all'); ?> </a>
                                                <a class="btn btn-default btn-block unselectAllCB"><?php echo $this->lang->line('choice_remove'); ?> </a>
                                                <hr />
                                                <a class="btn btn-danger btn-block" id="deletePayments"><i class="fa fa-trash-o"></i> <?php echo $this->lang->line('erasure'); ?></a>
                                    </div>
                                    <!-- end widget content -->

                                </div>
                                <!-- end widget div -->

                            </div>
                            <!-- end widget -->

                        </article>
                        <!-- WIDGET END -->

                    </div>
                    <!-- end row -->

                </section>
                <!-- end widget grid -->

            </div>
            <!-- END MAIN CONTENT -->

        </div>
        <!-- END MAIN PANEL -->
        <div id='dialog_invoiceUpload' title='Dialog Simple Title' style="display: none;">
            <table id="invoiceUploadTbl">
                <form class="" id="invoiceUploadForm">
                    <tbody>
                      
                        <tr class="editTd">
                            <td>
                                <div class="form-group">
                                    <input type="file" class="btn btn-default" name="invoiceInputFile" id="invoiceInputFile" accept="application/pdf" />
                                    <input type="hidden" id="pId" name="pId" value="0" />
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </form>
            </table>
        </div>
        <div id='dialog_insertPayment' title='Dialog Simple Title' style="display: none;">
            <div id="insertPaymentDiv">
                <form id="insertPaymentForm" class="smart-form" method="post" action="">
                    <input type="hidden" name="ciId" id="ciId" value="<?php print $invoice->ciId; ?>" />
                    <fieldset>
                        <div class="row">
                            <section class="col col-6"> 
                                <label class="label"><?php echo $this->lang->line('sum'); ?></label>
                                <label class="input">
                                    <input type="text" id="apTotal" name="apTotal" value="<?php print number_format($invoice->total, 2); ?>" class="form-control" autocomplete="off" />
                                </label>
                            </section>
                        </div>
                        <div class="row">
                            <section class="col col-6">
                                <label class="label"><?php echo $this->lang->line('date'); ?></label>
                                <label class="input"> <i class="icon-append fa fa-calendar"></i> 
                                    <input type="text" id="cpDate" name="cpDate" value="<?php print date('d/m/Y'); ?>"  class="form-control" data-dateformat="dd/mm/yy" autocomplete="off" />
                                </label>
                            </section>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
        <div id='dialog_showPS' title='Dialog Simple Title' style="display: none;">
            <table id="showPSForm" class="table table-hover">
                <thead>
                    <th><?php echo $this->lang->line('name'); ?></th>
                    <th><?php echo $this->lang->line('telephone'); ?></th>
                    <th><?php echo $this->lang->line('sum'); ?></th>
                </thead>

                <tbody id="tbodyPS">
                </tbody>

            </table>
        </div>
        <input type="hidden" id="customerId" name="customerId" value="<?php print $invoice->customerId; ?>" />
        <script>
            function setPaymentPaid(pId) {
                if (confirm('<?php echo $this->lang->line('Mark_Paid'); ?>')) {
                    var data = {};
                    data.paymentId = pId;
                    $.post(root + 'admin/ajax/setPaymentPaid', {
                        data: data
                    }, function(d) {
                        if (d.result) {
                            window.location.reload();
                        }
                    }, 'json');
                }
            }

            function createCustomerPayment() {

                if (confirm('<?php echo $this->lang->line('Check_again'); ?>!')) {
                    var data = {};
                    data.customerId = $('#customerId').val();
                    data.campaigns = $(".campsToPayCB:checked").map(function() {
                        return $(this).val();
                    }).get();
                    data.uptoDate = $('#uptoDate').val();
                    if (data.campaigns.length == 0) {
                        alert('<?php echo $this->lang->line('No_campaigns_selected'); ?>');
                        return false;
                    }
                    $.post(root + 'admin/ajax/createCustomerPayment', {
                        data: data
                    }, function(d) {
                        if (d.result) {
                            window.location.reload();
                        }
                    }, 'json');
                } else {
                    return false;
                }
            }

            $(document).ready(function() {

                // Modal Link
                $('#doLeadsPaymentsBtn').on('click', function() {

                    $("#dialog_insertPayment").dialog({
                        autoOpen: false,
                        width: 400,
                        resizable: true,
                        modal: true,
                        title: "<div class='widget-header'><h4><i class='fa fa-edit'></i> <?php echo $this->lang->line('New_credit_movement'); ?></h4></div>",
                        buttons: [{
                            html: "<i class='fa fa-check'></i>&nbsp; <?php echo $this->lang->line('confirm'); ?>",
                            "class": "btn btn-info",
                            click: function() {
                                var data = {};
                                data.ciId = $('#ciId').val();
                                data.apTotal = $('#apTotal').val();
                                data.cpDate = $('#cpDate').val();
                                if (data.apTotal == 0) {
                                    alert('<?php echo $this->lang->line('write_amount'); ?>...');
                                    return false; 
                                }
                                $.post(root + 'admin/ajax/insertInvoicePayment', {
                                    data: data
                                }, function(d) {
                                    if (d.result) {
                                        window.location.reload();
                                    }
                                }, 'json');
                            }
                        }, {
                            html: "<i class='fa fa-times'></i>&nbsp; <?php echo $this->lang->line('cancel'); ?>",
                            "class": "btn btn-default",
                            click: function() {
                                //$('.deliveryRow[rel="' + id + '"]').removeClass('highlightTD'); 
                                $(this).dialog("close");
                            }
                        }]
                    });
                    $('#dialog_insertPayment').dialog('open');

                });

                // Modal Link
                $('.uploadInvoiceBtn').click(function() {
                    var pId = $(this).attr('rel');
                    $("#dialog_invoiceUpload").dialog({
                        autoOpen: false,
                        width: 300,
                        resizable: true,
                        modal: true,
                        title: "<div class='widget-header'><h4><i class='fa fa-edit'></i> <?php echo $this->lang->line('Upload_an_invoice'); ?></h4></div>",
                        buttons: [{
                            html: "<i class='fa fa-edit'></i>&nbsp; <?php echo $this->lang->line('savefeminsit'); ?>",
                            "class": "btn btn-success",
                            click: function() {
                                if ($('#invoiceInputFile').val() == '') {
                                    $.smallBox({
                                        title: "<?php echo $this->lang->line('no_file_selected'); ?>!",
                                        //content : "<i class='fa fa-clock-o'></i> <i>2 seconds ago...</i>",
                                        color: "#C46A69",
                                        iconSmall: "fa fa-ban bounce animated",
                                        timeout: 2500
                                    });
                                    return false;
                                } else {
                                    $('#pId').val(pId);
                                    var fdata = new FormData($('#invoiceUploadForm')[0]);
                                    var url = root + 'admin/customers/invoiceUploadAction';
                                    $.ajax({
                                        url: url,
                                        type: 'POST',
                                        data: fdata,
                                        async: true,
                                        success: function(data) {
                                            $('#dialog_invoiceUpload').dialog("close");
                                            window.location.reload();
                                        },
                                        cache: false,
                                        contentType: false,
                                        processData: false
                                    });
                                    //$(this).dialog("close");
                                }
                            }
                        }, {
                            html: "<i class='fa fa-times'></i>&nbsp; <?php echo $this->lang->line('cancel'); ?>",
                            "class": "btn btn-default",
                            click: function() {
                                //$('.deliveryRow[rel="' + id + '"]').removeClass('highlightTD'); 
                                $(this).dialog("close");
                            }
                        }]
                    });
                    $('#dialog_invoiceUpload').dialog('open');
                    return false;
                });

                $("#cpDate").datepicker({
                    dateFormat: 'dd/mm/yy',
                    defaultDate: new Date(),
                    changeMonth: true,
                    numberOfMonths: 1,
                    prevText: '<i class="fa fa-chevron-right"></i>',
                    nextText: '<i class="fa fa-chevron-left"></i>',
                    onClose: function(selectedDate) {
                        $("#from").datepicker("option", "maxDate", selectedDate);
                    }
                });

                $('body').on('click', '.selectAllCB', function() {
                    $('.leadCB').prop('checked', true);
                    $('.leadCB').parent().parent().addClass('leadRow_selected');
                });
                $('.unselectAllCB').on('click', function() {
                    $('.leadCB').prop('checked', false);
                    $('.leadCB').parent().parent().removeClass('leadRow_selected');
                });

                $('#deletePayments').on('click', function() {
                    $("#dialog_showPS").dialog({
                        autoOpen: true,
                        width: 500,
                        resizable: true,
                        modal: true,
                        title: "<div class='widget-header'><h4><i class='fa fa-times'></i> <?php echo $this->lang->line('delete_payment'); ?> </h4></div>",
                        buttons: [{
                            html: "<i class='fa fa-check'></i>&nbsp; <?php echo $this->lang->line('confirm'); ?> ",
                            "class": "btn btn-info",
                            click: function() {
                                var lpData = {};
                                if ($('#isRefund').is(':checked')) lpData.isRefund = 1;
                                lpData.leadId = $(".leadCB:checked").map(function() {
                                    return $(this).val();
                                }).get();
                                $.post(root + 'admin/ajax/deletePayments', lpData, function(d) {
                                    if (d.result) {
                                        window.location.reload();
                                        //$('.paidTd_' + cpId).html('<span class="label label-success">שולם</span>');
                                    }
                                    if (!d.result) alert('<?php echo $this->lang->line('try_again'); ?>!');
                                }, 'json');
                            }
                        }, {
                            html: "<i class='fa fa-times'></i>&nbsp; <?php echo $this->lang->line('close'); ?>",
                            "class": "btn btn-default",
                            click: function() {
                                //$('.deliveryRow[rel="' + id + '"]').removeClass('highlightTD'); 
                                $(this).dialog("close");
                            }
                        }]
                    }).html('<input type="checkbox" id="isRefund" value="1" checked="checked" /> <?php echo $this->lang->line('customer_right'); ?>? ');
                });

                $('#createInvoice').on('click', function() {
                    $("#dialog_showPS").dialog({
                        autoOpen: true,
                        width: 500,
                        resizable: true,
                        modal: true,
                        title: "<div class='widget-header'><h4><i class='fa fa-times'></i> <?php echo $this->lang->line('customer_right'); ?> </h4></div>",
                        buttons: [{
                            html: "<i class='fa fa-check'></i>&nbsp; <?php echo $this->lang->line('confirm'); ?>",
                            "class": "btn btn-info",
                            click: function() {
                                var lpData = {};
                                lpData.customerId = $('#customerId').val();
                                lpData.leadId = $(".leadCB:checked").map(function() {
                                    return $(this).val();
                                }).get();
                                $.post(root + 'admin/ajax/insertInvoice', lpData, function(d) {
                                    if (d.result) {
                                        window.location.reload();
                                        //$('.paidTd_' + cpId).html('<span class="label label-success">שולם</span>');
                                    }
                                    if (!d.result) alert('<?php echo $this->lang->line('try_again'); ?>"!');
                                }, 'json');
                            }
                        }, {
                            html: "<i class='fa fa-times'></i>&nbsp; <?php echo $this->lang->line('close'); ?>",
                            "class": "btn btn-default",
                            click: function() {
                                //$('.deliveryRow[rel="' + id + '"]').removeClass('highlightTD'); 
                                $(this).dialog("close");
                            }
                        }]
                    }).html('');
                });

            });

            function showPaymentLeads(paymentId) {

                $.post(root + 'admin/ajax/getPaymentLeads', {
                    paymentId: paymentId
                }, function(d) {
                    //if(d.result) $('tr[rel="' + userId + '"]').hide();
                    $('#tbodyPS').html(d.data);
                    $("#dialog_showPS").dialog({
                        autoOpen: false,
                        width: 500,
                        resizable: true,
                        modal: true,
                        title: "<div class='widget-header'><h4><i class='fa fa-bullseye'></i> " + d.cnt + " <?php echo $this->lang->line('subscribers'); ?> </h4></div>",
                        buttons: [{
                            html: "<i class='fa fa-times'></i>&nbsp; <?php echo $this->lang->line('close'); ?>",
                            "class": "btn btn-default",
                            click: function() {
                                //$('.deliveryRow[rel="' + id + '"]').removeClass('highlightTD'); 
                                $(this).dialog("close");
                            }
                        }]
                    });
                    $('#dialog_showPS').dialog('open');
                }, 'json');

            }

            function setCpPaid(cpId) {
                var data = {};
                data.table = 'customers_payments';
                data.idColumn = 'paymentId';
                data.id = cpId;
                data.dataColumn = 'isPaid';
                data.value = 1;
                $.post(root + 'admin/dashboard/changeStatusAjax', data, function(d) {
                    if (d.result) {
                        $('.paidTd_' + cpId).html('<span class="label label-success"><?php echo $this->lang->line('paid'); ?></span>');
                    }
                    if (!d.result) alert('<?php echo $this->lang->line('try_again'); ?>!');
                }, 'json');
            }

            function delLp(paymentId) {
                $("#dialog_showPS").dialog({
                    autoOpen: true,
                    width: 500,
                    resizable: true,
                    modal: true,
                    title: "<div class='widget-header'><h4><i class='fa fa-times'></i> <?php echo $this->lang->line('delete_payment'); ?> </h4></div>",
                    buttons: [{
                        html: "<i class='fa fa-check'></i>&nbsp; <?php echo $this->lang->line('confirm'); ?>",
                        "class": "btn btn-info",
                        click: function() {
                            var lpData = {};
                            lpData.paymentId = paymentId;
                            if ($('#isRefund').is(':checked')) lpData.isRefund = 1;
                            $.post(root + 'admin/ajax/deleteCustomerPayment', lpData, function(d) {
                                if (d.result) {
                                    window.location.reload();
                                    //$('.paidTd_' + cpId).html('<span class="label label-success">שולם</span>');
                                }
                                if (!d.result) alert('<?php echo $this->lang->line('try_again'); ?>!');
                            }, 'json');
                        }
                    }, {
                        html: "<i class='fa fa-times'></i>&nbsp; <?php echo $this->lang->line('close'); ?>",
                        "class": "btn btn-default",
                        click: function() {
                            //$('.deliveryRow[rel="' + id + '"]').removeClass('highlightTD'); 
                            $(this).dialog("close");
                        }
                    }]
                }).html('<input type="checkbox" id="isRefund" value="1" checked="checked" /> <?php echo $this->lang->line('customer_right'); ?>? ');

            }

            function exportCustomerPayments() {
                var data = {};
                data.start = $('#startDate').val();
                data.end = $('#endDate').val();
                data.ciId = $('#ciId').val();
                var cId = $('#customerId').val();
                $.post(root + 'admin/leads/exportCustomerPaymentsReport/' + cId, {
                    data: data
                }, function(d) {
                    console.log(d.file);
                    window.location.assign(root + 'assets/export/' + d);
                }, 'json');
            }
        </script>
        <style>
            #ui-datepicker-div {
                z-index: 99999 !important;
            }
        </style>