<script src="https://cdn.jsdelivr.net/npm/jsframe.js/lib/jsframe.min.js"></script>
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.3/css/all.css" crossorigin="anonymous">

<div id="task-bar" class="task-bar shadow">
    <div class="nav-logoImg">
        <img src="<?php echo site_url(); ?>assets/img/logo.png" alt="">
    </div>
    <div class="nav-images">
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('dashboard'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/icon1.png" class="icon" rel="dashboard" id="Dashboard">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('customers'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/icon6.png" class="icon" rel="customers" id="Customers">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('invoices'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/icon8.png" class="icon" rel="invoices" id="Invoices">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('page_financial'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/icon7.png" class="icon" id="finance">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('orders'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/icon5.png" class="icon" rel="orders" id="<?php echo $this->lang->line('orders'); ?>">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('accounts'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/icon4.png" class="icon" id="Window-07">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('daily_log'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/icon3.png" class="icon" id="Window-08">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('orders'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/shopping-list.png" class="icon" id="Window-06">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('warehouses'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/warehouse.png" class="icon" id="Window-06">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('settings'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/settings.png" class="icon" id="Window-06">
        </div>
        <div class="navImg-holder" data-toggle="tooltip" title="<?php echo $this->lang->line('users'); ?>">
            <img src="<?php echo site_url(); ?>assets/img/icon2.png" class="icon" id="Window-06">
        </div>
    </div>
</div>

<div class="open-windows">
    <div class="user-info">
        <div class="profile-avatar" style="background: url('<?php echo site_url() . 'assets/img/logoNew.png'; ?>');"></div>
        <div class="frame-username text-white">אדמין</div>
        <div class="frame-username text-white"><i class="fas fa-globe"></i> עברית</div>
        <div class="frame-username text-white">14:11</div>
    </div>
</div>

<script>
    var i = 0;
    const jsFrame = new JSFrame();

    $(function() {
        $('[data-toggle="tooltip"]').tooltip()
    })

    $(document).on('click', '.icon', function() {
        var page = $(this).attr("rel");
        var name = $(this).attr("id");
        if (jsFrame.getWindowByName(name) === null) {
            const frame = jsFrame.create({
                title: name,
                name: name,
                left: (Number(window.innerWidth) / 2) - 325,
                top: 60,
                width: 850,
                height: window.innerHeight - 200,
                appearanceName: 'yosemite',
                html: '<div class="iframe_content all_content_' + name + '"></div>',
                //url: root + 'admin/' + page
            });
            //$('.all_content_' + name).load(page + ' .container-fluid main');
            $( '.all_content_' + name ).load( page + ' .container-fluid main' , function(data) {
                var scripts = $(data).find("script");
                //console.log(scripts);
                if (scripts.length) {
                    $(scripts).each(function() {
                        if ($(this).attr("src")) {
                            $.getScript($(this).attr("src"));
                        }
                        else {
                            eval($(this).html());
                        }
                    });
                }
            });
            frame.setControl({
                styleDisplay: 'inline',
                maximizeButton: 'zoomButton',
                demaximizeButton: 'dezoomButton',
                minimizeButton: 'minimizeButton',
                deminimizeButton: 'deminimizeButton',
                hideButton: 'closeButton',
                animation: true,
                animationDuration: 150,
            });
            frame.on('frame', 'focus', (data) => {
                const frame = data.target;
                //console.log(`${frame.getName()} got focused.`);
            });
            frame.on('frame', 'blur', (data) => {
                const frame = data.target;
                //console.log(`${frame.getName()} lost focused.`);
            });
            frame.on('frame', 'move', (data) => {
                const position = data.pos;
                if (Number(position.x) <= 0) {
                    if (position.y <= 0) {
                        frame.setPosition(0, 0);
                    } else {
                        frame.setPosition(0, position.y);
                    }
                }
                if (Number(position.x) > (Number(window.innerWidth) * 0.65)) {
                    if (position.y <= 0) {
                        frame.setPosition(window.innerWidth * 0.65, 0);
                    } else {
                        frame.setPosition(window.innerWidth * 0.65, position.y);
                    }
                }
                if (Number(position.y) <= 0) {
                    if (position.x <= 0) {
                        frame.setPosition(0, 0);
                    } else if (Number(position.x) > (Number(window.innerWidth) * 0.65)) {
                        frame.setPosition(Number(window.innerWidth) * 0.65, 0);
                    } else {
                        frame.setPosition(position.x, 0);
                    }
                }
                if (Number(position.y) > (Number(window.innerHeight) * 0.11)) {
                    if (position.x <= 0) {
                        frame.setPosition(0, window.innerHeight * 0.11);
                    } else if (Number(position.x) > (Number(window.innerWidth) * 0.65)) {
                        frame.setPosition(Number(window.innerWidth) * 0.65, window.innerHeight * 0.11);
                    } else {
                        frame.setPosition(position.x, window.innerHeight * 0.11);
                    }
                }
            });
            frame.on('frame', 'resize', (data) => {
                const size = data.size;
                if (Number(size.width) < 650) {
                    frame.setSize(650, size.height);
                }
                if (Number(size.height) > window.innerHeight - 150) {
                    frame.setSize(size.width, window.innerHeight - 150);
                }
            });
            frame.show();
        } else {
            const frame = jsFrame.getWindowByName(name);
            frame.requestFocus();
        }
    });
    $(document).on('click', 'a', function(e) {
        e.preventDefault();
        var page = $(this).attr("href");
        var wName = $(this).attr("title");
        var pageFinal = page.replace(root, "/");
        var name = pageFinal;
        var final_name = name.replace(/\//g, '_');

        if (wName == undefined) {
            i++;
            name = name + '_' + i;
        }
        if (page != '#' && page != '#0') {
            const frame = jsFrame.create({
                title: wName,
                name: name,
                left: (Number(window.innerWidth) / 2) - 325,
                top: 10,
                width: 650,
                height: window.innerHeight - 200,
                appearanceName: 'yosemite',
                html: '<div class="iframe_content all_content_' + final_name + '"></div>',
                //url: root + 'admin/' + page,
                setFrameInFrame: false
            });
            //$('.all_content_' + final_name).load(page + ' .container-fluid main');
            $('.all_content_' + final_name ).load( page + ' .container-fluid main' , function(data) {
                var scripts = $(data).find("script");
                if (scripts.length) {
                    $(scripts).each(function() {
                        if ($(this).attr("src")) {
                            $.getScript($(this).attr("src"));
                        }
                        else {
                            eval($(this).html());
                        }
                    });
                }
            });
            frame.setControl({
                styleDisplay: 'inline',
                maximizeButton: 'zoomButton',
                demaximizeButton: 'dezoomButton',
                minimizeButton: 'minimizeButton',
                deminimizeButton: 'deminimizeButton',
                hideButton: 'closeButton',
                animation: true,
                animationDuration: 150,
            });

            frame.on('frame', 'focus', (data) => {
                const frame = data.target;
                //console.log(`${frame.getName()} got focused.`);
            });

            // Register 'blur'(focus out) event
            frame.on('frame', 'blur', (data) => {
                const frame = data.target;
                //console.log(`${frame.getName()} lost focused.`);
            });
            frame.on('frame', 'move', (data) => {
                const position = data.pos;
                if (Number(position.x) <= 0) {
                    if (position.y <= 0) {
                        frame.setPosition(0, 0);
                    } else {
                        frame.setPosition(0, position.y);
                    }
                }
                if (Number(position.x) > (Number(window.innerWidth) * 0.65)) {
                    if (position.y <= 0) {
                        frame.setPosition(window.innerWidth * 0.65, 0);
                    } else {
                        frame.setPosition(window.innerWidth * 0.65, position.y);
                    }
                }
                if (Number(position.y) <= 0) {
                    if (position.x <= 0) {
                        frame.setPosition(0, 0);
                    } else if (Number(position.x) > (Number(window.innerWidth) * 0.65)) {
                        frame.setPosition(Number(window.innerWidth) * 0.65, 0);
                    } else {
                        frame.setPosition(position.x, 0);
                    }
                }
                if (Number(position.y) > (Number(window.innerHeight) * 0.11)) {
                    if (position.x <= 0) {
                        frame.setPosition(0, window.innerHeight * 0.11);
                    } else if (Number(position.x) > (Number(window.innerWidth) * 0.65)) {
                        frame.setPosition(Number(window.innerWidth) * 0.65, window.innerHeight * 0.11);
                    } else {
                        frame.setPosition(position.x, window.innerHeight * 0.11);
                    }
                }
            });
            frame.on('frame', 'resize', (data) => {
                const size = data.size;
                if (Number(size.width) < 650) {
                    frame.setSize(650, size.height);
                }
                if (Number(size.height) > window.innerHeight - 150) {
                    frame.setSize(size.width, window.innerHeight - 150);
                }
            });
            frame.show();
        }
    });
    $(document).on('click', 'button', function(e) {
        e.preventDefault();
        var attr = $(this).attr('data-bs-target');
        var pageType = $(this).parents('div[role="main"]').attr('class');
        if (typeof attr !== 'undefined' && attr !== false) {
            var modal = attr.replace("#", "");
            $('#' + modal).modal('hide');
            var $model = $('#' + modal + ' .modal-body').clone();
            e.preventDefault();
            const frame = jsFrame.create({
                title: modal,
                name: modal,
                left: (Number(window.innerWidth) / 2) - 325,
                top: 60,
                width: 850,
                height: window.innerHeight - 200,
                appearanceName: 'yosemite',
                html: '<div class="iframe_content all_content_' + modal + '"></div>',
                //url: root + 'admin/' + page,
                setFrameInFrame: false
            });
            $('.all_content_' + modal).append($model);
            $('.all_content_' + modal).find('#' + modal).show();
            $('.all_content_' + modal).addClass(pageType);
            frame.setControl({
                styleDisplay: 'inline',
                maximizeButton: 'zoomButton',
                demaximizeButton: 'dezoomButton',
                minimizeButton: 'minimizeButton',
                deminimizeButton: 'deminimizeButton',
                hideButton: 'closeButton',
                animation: true,
                animationDuration: 150,
            });
            frame.on('frame', 'focus', (data) => {
                const frame = data.target;
            });
            frame.on('frame', 'blur', (data) => {
                const frame = data.target;
            });
            frame.on('frame', 'move', (data) => {
                const position = data.pos;
                if (Number(position.x) <= 0) {
                    if (position.y <= 0) {
                        frame.setPosition(0, 0);
                    } else {
                        frame.setPosition(0, position.y);
                    }
                }
                if (Number(position.x) > (Number(window.innerWidth) * 0.65)) {
                    if (position.y <= 0) {
                        frame.setPosition(window.innerWidth * 0.65, 0);
                    } else {
                        frame.setPosition(window.innerWidth * 0.65, position.y);
                    }
                }
                if (Number(position.y) <= 0) {
                    if (position.x <= 0) {
                        frame.setPosition(0, 0);
                    } else if (Number(position.x) > (Number(window.innerWidth) * 0.65)) {
                        frame.setPosition(Number(window.innerWidth) * 0.65, 0);
                    } else {
                        frame.setPosition(position.x, 0);
                    }
                }
                if (Number(position.y) > (Number(window.innerHeight) * 0.11)) {
                    if (position.x <= 0) {
                        frame.setPosition(0, window.innerHeight * 0.11);
                    } else if (Number(position.x) > (Number(window.innerWidth) * 0.65)) {
                        frame.setPosition(Number(window.innerWidth) * 0.65, window.innerHeight * 0.11);
                    } else {
                        frame.setPosition(position.x, window.innerHeight * 0.11);
                    }
                }
            });
            frame.on('frame', 'resize', (data) => {
                const size = data.size;
                if (Number(size.width) < 650) {
                    frame.setSize(650, size.height);
                }
                if (Number(size.height) > window.innerHeight - 150) {
                    frame.setSize(size.width, window.innerHeight - 150);
                }
            });

            var total_before_vat = 0;
            var vat = 0;
            var total = 0;

            $('.iframe_content').find('.datepicker').datepicker({
                dateFormat: "dd/mm/yy",
                isRTL: true,
                prevText: '<i class="fa fa-chevron-left"></i>',
                nextText: '<i class="fa fa-chevron-right"></i>',
            });

            $(document).on('click', '#add_item', function() {
                var $table = $('.iframe_content').find('#invoice_table');
                var new_line = $table.find('tr.items').first().clone();
                new_line.find(".item_description").val("");
                new_line.find(".item_unit").val("");
                new_line.find(".item_price").val("");
                new_line.find(".full_price").val("");
                new_line.append('<a href="#0" class="remove_this_item btn bg-danger btn-sm text-white"><i class="fa fa-times"></i></a>');
                new_line.insertBefore('.iframe_content #btns_group');
                calcTotal();
            });

            $(document).on('click', '#add_payment_line', function() {
                var $table = $('#payment_table');
                var new_line = $table.find('tr.payments').first().clone();
                new_line.find("input.total_payment").val("");
                new_line.append('<a href="#0" class="remove_this_payment btn bg-danger btn-xs text-white"><i class="fa fa-times"></i></a>');
                new_line.insertBefore('#btns_group_payments');
            });


            $(document).on('click', '.remove_this_item', function() {
                $(this).parent().remove();
                calcTotal();
            });

            $(document).on('click', '#save_invoice', function() {
                $('#createInvoiceForm').submit();
            });

            $(document).on('change', '#invoice_for', function() {
                var data = {};
                data.customerId = $(this).val();
                $.post(root + 'admin/invoices/getCustomerDetailsforInvoice', data, function(d) {

                    if (d.result == true) {
                        $('.iframe_content').find('#customer_phone_number').html(d.phoneNumber);
                        $('.iframe_content').find('#customer_address').html(d.address);
                        $('.iframe_content').find('#customer_email').html(d.email);
                        $('.iframe_content').find('#customerId').html(d.customerId);
                        $('.iframe_content').find('#customer_inv_id').html(d.invID);
                    } else {
                        $('.iframe_content').find('#customer_phone_number').html("");
                        $('.iframe_content').find('#customer_address').html("");
                        $('.iframe_content').find('#customer_email').html("");
                        $('.iframe_content').find('#customerId').html("");
                        $('.iframe_content').find('#customer_inv_id').html("");
                    }

                }, 'json');
            });

            $(document).on('change', '.item_price', function() {
                calcTotal();
            });

            $(document).on('change', '.item_unit', function() {
                calcTotal();
            });
            $(document).on('change', '.select2Custom', function() {
                var elem = $(this);
                var data = {};
                data.id = $(this).val();
                $.post(root + 'admin/invoices/getItemPrice', data, function(d) {
                    if (d.price) {
                        elem.parent().parent().find('.item_price').val(d.price);
                        calcTotal();
                    }
                }, 'json');
            });

            $('.iframe_content').find(".select2").select2({
                theme: "bootstrap-5",
            });
            $('.iframe_content').find('select.select2Custom').select2({
                placeholder: 'חפש פריטים',
                selectOnClose: false,
                tags: true,
                ajax: {
                    dataType: "json",
                    url: root + 'admin/invoices/getItems',
                    processResults: function(data) {
                        return {
                            results: data.results
                        }
                    }
                },
                "language": {
                    "noResults": function() {
                        return "חפדש פריטים";
                    }
                },
                theme: "bootstrap-5"
            });

            function calcTotal() {
                var full_total = 0;
                $('.iframe_content').find(".item_price").each(function(index) {
                    var elem = $(this);
                    var price = Number(elem.val());
                    var unit = Number(elem.parent().parent().find('.item_unit').val());
                    var priceF = price * unit;
                    elem.parent().parent().find('.full_price').val(priceF);
                    full_total = full_total + priceF;
                });
                var before_vat = full_total / 1.17;
                var vat = full_total - before_vat;
                $('.iframe_content').find('#total_before_vat').val(before_vat.toFixed(2));
                $('.iframe_content').find('#vat').val(vat.toFixed(2));
                $('.iframe_content').find('#total').val(full_total.toFixed(2));
            }

            frame.show();
        }
    });
</script>

<style>
    body {
        background: url('<?php echo site_url() . 'assets/img/frameBgCompressed.jpg'; ?>');
        background-size: cover;
        background-position: center;
        background-position-y: 100%;
    }
    a {
        font-size: 12px;
    }
    .dataTables_scrollBody {
        max-height: 350px !important;
    }
    .new_invoice_btn button {
        font-size: 12px;
    }
    .modal-lg, table.table.table-sm.dataTable.no-footer,.dataTables_scrollHeadInner {
        min-width: 100% !important;
        max-width: 100% !important;
        width: 100% !important;
    }
    page {
        font-size: 12px;
    }
</style>