<?php
if (
    !isset($permissions['finance']['invoices'])
    || isset($permissions['finance']['invoices'])
    && $permissions['finance']['invoices'] == 0
) redirect('admin/dashboard');

?>
<script src="https://cdn.lordicon.com/libs/mssddfmo/lord-icon-2.1.0.js"></script>
<div id="main p-0" role="main">
    <!-- <div class="header-bg shadow-sm p-0" style="background: url(https://images.pexels.com/photos/1475033/pexels-photo-1475033.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=750&w=1260)"> -->
    <!-- <div class="header-bg shadow-lg p-0" style="background: url(https://images.pexels.com/photos/1487834/pexels-photo-1487834.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=750&w=1260)"></div> -->
    <div id="content" style=" padding-top: 0px; ">
        <div class="container">
            <div class="row mt-3 justify-content-center">
                <div class="header_invoice_wrapper shadow">
                    <div class="fs-1 w-25 text-white d-flex align-items-center"><?php echo $this->lang->line('invoices'); ?></div class="fs-1">
                    <div class="new_invoice_btn">
                        <button type="button" class="shadow-lg add_invoice_button" data-bs-toggle="modal" data-bs-target="#myModal" title="<?php echo $this->lang->line('new_invoice'); ?>">
                            <lord-icon src="https://cdn.lordicon.com/mecwbjnp.json" trigger="loop" delay="1000" colors="primary:#356359,secondary:#00bcd4" style="width:32px;height:32px">
                            </lord-icon>
                            <span class="pt-1 text-dark">
                                <?php echo $this->lang->line('new_invoice'); ?>
                            </span>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter cancel_invoice p-2" style="width: 50px;" data-bs-toggle="collapse" href="#date_search" role="button" aria-expanded="false" aria-controls="date_search">
                            <i class="fa fa-search "></i> </button>
                        <button type="button" class="shadow-lg excel_exporter" data-bs-toggle="modal" data-bs-target="#ExcelExportModal">
                            <i class="fas fa-file-excel text-success px-2"></i>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter  p-2" style="width: 50px;" data-bs-toggle="modal" id="" rel-invoice="-1" data-bs-target="#DeleteInvoice">
                            <i class="fas fa-file-pdf text-warning"></i>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter  p-2" style="width: 50px;" data-bs-toggle="modal" id="" rel-invoice="-1" data-bs-target="#DeleteInvoice">
                            <i class="fas fa-copy text-primary"></i>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter cancel_invoice p-2" style="width: 50px;" data-bs-toggle="modal" id="deleteInvoiceButton" rel-invoice="-1" data-bs-target="#DeleteInvoice">
                            <i class="pt-1 me-1 fas fa-trash-alt text-danger"></i>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter view_invoice p-2" style="width: 50px;" data-bs-toggle="modal" id="viewInvoiceButton" rel-invoice="-1" data-bs-target="#DeleteInvoice">
                            <i class="pt-1 me-1 fas fa-eye text-success"></i>
                        </button>
                    </div>
                </div>
                <div class="collapse w-100" id="date_search">
                    <div class="date-searchWrapper" style="margin-left: 10px;">
                        <div class="p-3 w-50 bg-white mx-auto" style="border-radius: 0 0 20px 20px; float: left;">
                            <form class="w-75 mx-auto" method="POST">
                                <div class="form-group">
                                    <div class="">
                                        <label>מפיץ</label>
                                        <select multiple style="width:100%" class="select2" name="customerId[]">
                                            <?php $suppliersIds = array();
                                            if (isset($_POST['suppliersIds'])) $suppliersIds = $_POST['suppliersIds'];
                                            foreach ($suppliers as $supplier) : ?>
                                                <option value="<?php print $supplier->supplier_id; ?>" <?php if (in_array($supplier->supplier_id, $suppliersIds)) print 'selected="selected"'; ?>><?php print $supplier->name; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <div class="form-group">
                                            <div class="input">
                                                <input class="form-control text-center" name="firstPayDate" id="firstPayDate" type="text" placeholder="מתאריך" value="<?php if (isset($_POST['firstPayDate'])) print $_POST['firstPayDate']; ?>" autocomplete="off" style="width: 100%;" />
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="input">
                                                <input class="form-control text-center" name="firstPayToDate" id="firstPayToDate" type="text" placeholder="עד תאריך" value="<?php if (isset($_POST['firstPayToDate'])) print $_POST['firstPayToDate']; ?>" autocomplete="off" style="width: 100%;" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="button-group" style="margin-top: 24px;">
                                    <div class="form-group">
                                        <button class="btn btn-danger p-1" type="submit"><i class="fa fa-search"></i>חפש</button>
                                        <button class="btn btn-default p-1" type="button" onclick="clearAll();"><i class="fa fa-eraser"></i>נקה הכל</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <hr class="bg-white mt-5" style="border-radius: 30px; padding: 2px;" />
                    <div class=" table-responsive card card-body">
                        <table class="table table-sm" id="dt_basic2">
                            <thead>
                                <th>מס חשבונית</th>
                                <th>מפיץ</th>
                                <th>חשבון</th>
                                <th>סכום</th>
                                <th>תאריך</th>
                                <th>DeleteComment</th>
                            </thead>
                            <tbody>
                                <?php foreach ($invoices as $invoice) { ?>
                                    <tr rel-invoice="<?php echo $invoice->invoice_id; ?>">
                                        <td style="width: 50px; max-width: 50px;"> <span class="fw-bold fs-6 text-primary"><?php echo $invoice->invoice_id; ?> </span></td>
                                        <td>
                                            <?php echo getSupplierName($invoice->supplier_id); ?>
                                        </td>
                                        <td>
                                            <?php echo $invoice->accountId; ?>
                                        </td>

                                        <td class="<?php echo $invoice->cancel_id > 0 ? "text-danger fw-bold" : ""; ?>"><?php echo $invoice->invoice_total; ?></td>
                                        <td><?php echo date("d/m/Y", strtotime($invoice->dateCreation)); ?></td>
                                        <td style="width: 300px; max-width: 300px;">
                                            <div class="w-100 mx-auto">
                                                <?php echo $invoice->deleteComment; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php }; ?>
                            </tbody>
                            <tfoot>
                                <!-- <tr>
                                        <td colspan="2"></td>
                                        <td><strong><?php echo number_format($balance, 2); ?></strong></td>
                                        <td colspan="3"></td>
                                    </tr> -->
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal " id="myModal" role="dialog">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content position-relative">
            <div class="close_modal" id="close_modal">
                <i class="fas fa-times-circle text-danger"></i>
            </div>
            <div class="modal-body" style="background-color: #f5f5f5;">
                <div id="content">
                    <form action="<?php echo site_url(); ?>admin/invoices/createInvoiceOnlySupplier" method="POST" id="createInvoiceForm" autocomplete="OFF">
                        <div class="first-stage position-relative" id="page_one">
                            <div class="form-header">
                                <div class="invoice-head">
                                    <label for=""><?php echo $this->lang->line('invoices'); ?></label>
                                    <input class="form-control" value="<?php echo getSupplierNewInvoiceNo(); ?>" name="invoice_code" readonly>
                                </div>
                                <div class="invoice-head">
                                    <label for=""><?php echo $this->lang->line('date'); ?></label>
                                    <input type="text" value="<?php $now = date('Y-m-d');
                                                                echo date("d/m/Y", strtotime($now)); ?>" name="invoice_date" id="invoice_date" class="form-control" />
                                </div>
                            </div>
                            <div class="">
                                <div class="form-full">
                                    <label for=""><?php echo $this->lang->line('supplier'); ?></label>
                                    <div class="selectorHolder">
                                        <select class="select2" id="invoice_for" name="invoice_for">
                                            <optgroup class="companies_list_from" label="ספקים" id="invoice_for" name="invoice_for">
                                                <option value="">נא בחר</option>
                                                <?php foreach ($suppliers as  $supplier) { ?>
                                                    <option value="<?php echo $supplier->supplier_id; ?>"><?php echo $supplier->name; ?></option>
                                                <?php  } ?>
                                            </optgroup>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-full">
                                    <div class="invoice-custom_75 d-flex" style="width: 80%;">
                                        <label for="" class="" style="width: 20.3%;">
                                            <div style="max-width: 20px;">
                                                הערת מנהל
                                            </div>
                                        </label>
                                        <input id="fill_boss_Comment1" class="form-control w-75" name="boss_Comment">
                                    </div>
                                    <div class="invoice-custom_25 d-flex" style="width: 30%">
                                        <label class="w-50">יתרת הלקוח</label>
                                        <input id="customer_credit" type="text" class="form-control w-50 p-1 text-center" readaonly value="" readonly name="customer_credit" style="font-size:8px; color: tomato !important; font-weight: bold !important;" />
                                    </div>
                                </div>
                                <div class="form-full">
                                    <label for="">פרטים</label>
                                    <input class="form-control fill_cust_comment" name="custComment" id="custComment">
                                </div>
                                <div class="form-full">
                                    <label for="">מחסן</label>
                                    <div class="selectorHolder">
                                        <select name="storage" class="select2" id="storage">
                                                <?php foreach ($warehouse as  $house) { ?>
                                                    <option value="<?php echo $house->ID; ?>"><?php echo $house->Name; ?></option>
                                                <?php  } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-full" style="margin-top: 50px;">
                                    <label for="">הערות</label>
                                    <textarea class="form-control" style="width: 85%; height: 150px;" placeholder="הזן את ההערה שלך" id="comment1" name="comment1"></textarea>
                                </div>
                            </div>
                            <div class="row w-100 d-flex justify-content-end m-0">
                                <button type="button" class="btn btn-success rounded float-left p-1 next-stage" style="width: 100px;">
                                    אשור
                                </button>
                            </div>
                        </div>
                        <page size="A4" style="display: none;">
                            <div class="second_stage_header row align-items-start">
                                <div class="right-section w-50">
                                    <div class="w-50 m-2">
                                        <label for="" class="me-1"><?php echo $this->lang->line('invoices'); ?>: </label>
                                        <label for="" class="fw-bold"><?php echo getSupplierNewInvoiceNo(); ?></label>
                                    </div>
                                    <div class="w-50 m-2">
                                        <label for="" class="me-1" name="customer" id="customer">לקוח: </label>
                                        <label for=""></label>
                                    </div>
                                    <div class="form-full w-50 m-2">
                                        <label for="" class="me-1">פרטים: </label>
                                        <input class="form-control" name="cust_comment" id="cust_comment" readonly>
                                    </div>
                                </div>
                                <div class="left-section w-50">
                                    <div class="invoice-head w-50 m-2">
                                        <label for="" class="me-1">תאריך: </label>
                                        <input class="form-control" value="" name="invoice_date1" id="invoice_date1">
                                    </div>
                                </div>
                            </div>
                        
                      
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#listview" rel-invoice="-1" data-bs-target="#DeleteInvoice">View List</button>

                            <div class="row container-sm mx-auto p-0">
                                <div class="col col-lg-12 col-md-12 col-sm-12" id="invoice_details">
                                    <table class="table" id="invoice_table">
                                        <thead>
                                            <tr>
                                                <th colspan="3" style=" width: 100px; ">BARCODE</th>
                                                <th><?php echo $this->lang->line('description'); ?></th>
                                                <th><?php echo $this->lang->line('unit'); ?></th>
                                                <th><?php echo $this->lang->line('unit_price'); ?></th>
                                                <th><?php echo $this->lang->line('sum'); ?></th>
                                                <th><?php echo $this->lang->line('actions'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="items">
                                                <td colspan="3" style="width: 40%;">
                                                    <select style="width:400px;" name="items[product_id][]" class="select2Custom"></select>
                                                    <input type="hidden" name="items[code][]">
                                                </td>
                                                <td>
                                                    <input type="text" value="" name="items[description][]" class="item_desc form-control text-center" readonly="readonly" />
                                                </td>
                                                <td>
                                                    <input type="text" value="" name="items[unit][]" class="item_unit form-control text-center" />
                                                </td>
                                                <td>
                                                    <input type="text" value="" name="items[price][]" class="item_price form-control text-center" />
                                                </td>
                                                <td>
                                                    <input type="text" value="" name="items[full_price][]" class="full_price form-control text-center" readonly="readonly" style="width: 100%;" />
                                                </td>
                                                <td>
                                                    <div href="#0" class="remove_this_item btn btn-sm bg-danger text-white">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                </td>
                                            </tr>

                                            <tr id="btns_group">
                                                <td colspan="7" style="text-align:center;">
                                                    <a href="#0" class="btn btn-success btn-circle p-1" id="add_item">
                                                        <i class="fa fa-plus"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="final_info">
                                    <div class="form-full">
                                        <textarea class="form-control w-75" style="height: 100px" placeholder="הערות" id="floatingTextarea" name="comment2"></textarea>
                                    </div>
                                    <div class="final_number">
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('total_before_vat'); ?></label>
                                            <input type="text" value="0" name="total_before_vat" class="fill_total_before_vat form-control w-50 text-center p-0" readonly />
                                        </div>
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('vat_17'); ?></label>
                                            <input type="text" value="0" name="vat" class="form-control w-50 fill_vat text-center p-0" readonly />
                                        </div>
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('total_shekel'); ?></label>
                                            <input type="text" value="0" name="total" class="fill_total form-control w-50 text-center p-0" readonly />
                                        </div>
                                    </div>
                                </div>

                                <div class="col col-lg-12 col-lg-12 col-sm-12">
                                    <div class="row justify-content-between">
                                        <div class="col-lg-3 d-flex align-items-center">
                                            <div class="invoice-custom_25 d-flex">
                                                <label class="w-50">יתרת הלקוח</label>
                                                <input type="text" class="form-control w-50 p-1 text-center" value="" readonly name="credit1" id="credit1">
                                            </div>
                                        </div>
                                        <div class="align-items-center col-lg-5 d-flex justify-content-end">
                                            <button type="button" class="reverse-stage btn btn-primary p-1"><i class="fas fa-angle-right me-1"></i>חזור</button>
                                            <a href="#0" class="btn btn-danger" id="close_invoiceForm" style=" margin: 0 10px !important;padding: 4px 20px !important;">
                                                <?php echo $this->lang->line('close'); ?>
                                            </a>
                                            <a href="#0" class="btn btn-success p-1 mr-1" id="save_invoice">
                                                <?php echo $this->lang->line('invoicing_save'); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </page>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- List View -->
<div class="modal fade" id="listview" tabindex="-1" role="dialog" aria-labelledby="listview" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle">List View</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
    
      </div>
    </div>
  </div>
</div>

<div class="modal" id="DeleteInvoice" role="dialog" style="display: none;">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content position-relative">
            <div class="close_modal" id="close_DeleteModal" rel-delete="true">
                <i class="fas fa-times-circle text-danger"></i>
            </div>
            <div class="modal-body" style="background-color: #f5f5f5;">
                <div id="content">
                    <form action="<?php echo site_url(); ?>admin/invoices/deleteSupplierInvoiceOnly" method="POST" id="deleteInvoiceForm" autocomplete="OFF">
                        <div class="first-stage">
                            <div class="form-header">
                                <div class="invoice-head">
                                    <label for=""><?php echo $this->lang->line('invoices'); ?></label>
                                    <input id="fill_invoice_code" class="form-control" value="" name="invoice_code" readonly>
                                </div>
                                <div class="invoice-head">
                                    <label for=""><?php echo $this->lang->line('date'); ?></label>
                                    <input id="fill_invoice_date" type="text" name="invoice_date" class="datepicker form-control" readonly />
                                </div>
                            </div>
                            <div class="form-full">
                                <label for=""><?php echo $this->lang->line('supplier'); ?></label>
                                <div class="selectorHolder">
                                    <input type="text" class="form-control w-100" id="fill_customer" readonly>
                                </div>

                            </div>
                            <div class="form-full">
                                <div class="w-75 invoice-custom_75 d-flex">
                                    <label for="" class="" style="width: 20%;">הערת מנהל</label>
                                    <input id="fill_boss_Comment" class="form-control w-75" value="אנא אל תפתח הזמנה גבוהה מ- 1000" name="boss_Comment" readonly>
                                </div>
                                <div class="w-25 invoice-custom_25 d-flex">
                                    <label class="w-50">יתרת הלקוח</label>
                                    <input id="fill_customer_credit" type="text" class="form-control w-50 p-1 text-center" value=""  name="customer_credit"  style="font-size:8px; color: tomato !important; font-weight: bold !important;" />
                                </div>
                            </div>
                            <div class="form-full">
                                <label for="">פרטים</label>
                                <input class="form-control fill_cust_comment" name="custComment" readonly>
                            </div>
                            <div class="form-full">
                                <label for="">מחסן</label>
                                <input id="fill_warehouse" class="form-control" placeholder="ראשון" name="invoice_customer" readonly>
                            </div>
                            <div class="form-full" style="margin-top: 50px;">
                                <label for="">הערות</label>
                                <textarea id="fill_comment1" class="form-control" style="width: 85%; height: 150px;" placeholder="הזן את ההערה שלך" name="comment1" readonly></textarea>
                            </div>
                            <div class="row w-100 d-flex justify-content-end m-0">
                                <button type="button" class="btn btn-primary rounded float-left p-1 next-stage" style="width: 100px;" rel-delete="true">
                                    אשור
                                </button>
                            </div>
                        </div>
                        <page size="A4" style="display: none;">
                            <div class="second_stage_header row align-items-start">
                                <div class="right-section w-50">
                                    <div class="w-50 m-2">
                                        <label for="" class="me-1"><?php echo $this->lang->line('invoices'); ?>: </label>
                                        <label for="" class="fw-bold invoiceCodeLabel text-danger"></label>
                                    </div>
                                    <div class="w-50 m-2">
                                        <label for="" class="me-1" name="customer"><?php echo $this->lang->line('supplier'); ?></label>
                                        <label for="" id="fill_customer2"></label>
                                    </div>
                                    <div class="form-full w-50 m-2">
                                        <label for="fill_cust_comment" class="me-1">פרטים: </label>
                                        <input id="fill_cust_comment" class="form-control fill_cust_comment" name="cust_comment" readonly>
                                    </div>
                                </div>
                                <div class="left-section w-50">
                                    <div class="invoice-head w-50 m-2">
                                        <label for="" class="me-1">תאריך: </label>
                                        <input id="fill_invoice_date1" class="form-control" value="" name="invoice_date1" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col col-lg-12 col-md-12 col-sm-12">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th colspan="3" style=" width: 100px; ">BARCODE</th>
                                                <th><?php echo $this->lang->line('description'); ?></th>
                                                <th><?php echo $this->lang->line('unit'); ?></th>
                                                <th><?php echo $this->lang->line('unit_price'); ?></th>
                                                <th><?php echo $this->lang->line('sum'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody id="fill_items" class="bg-white">
                                        </tbody>
                                    </table>
                                </div>
                                <div class="final_info">
                                    <div class="form-full">
                                        <textarea class="form-control w-75" style="height: 100px" placeholder="הערות" id="floatingTextarea" name="comment2"></textarea>
                                    </div>
                                    <div class="final_number">
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('total_before_vat'); ?></label>
                                            <input type="text" value="0" name="total_before_vat" class="fill_total_before_vat form-control w-50 text-center p-0" readonly />
                                        </div>
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('vat_17'); ?></label>
                                            <input type="text" value="0" name="vat" class="form-control w-50 fill_vat text-center p-0" readonly />
                                        </div>
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('total_shekel'); ?></label>
                                            <input type="text" value="0" name="total" class="fill_total form-control w-50 text-center p-0" readonly />
                                        </div>
                                    </div>
                                </div>

                                <div class="col col-lg-12 col-lg-12 col-sm-12">
                                    <div class="row justify-content-between">
                                        <div class="col-lg-3 d-flex align-items-center">
                                            <div class="invoice-custom_25 d-flex">
                                                <label class="w-50">יתרת הלקוח</label>
                                                <input type="text" class="form-control w-50 p-1 text-center" value="" name="credit1" id="fill_credit1">
                                            </div>
                                        </div>
                                        <div class="align-items-center col-lg-5 d-flex justify-content-end">
                                            <button type="button" class="reverse-stage btn btn-primary p-1" rel-delete="true"><i class="fas fa-angle-right me-1"></i>חזור</button>
                                            <a href="#0" class="btn btn-danger" id="close_invoiceForm" style=" margin: 0 10px !important;padding: 4px 20px !important;" rel-delete="true">
                                                <?php echo $this->lang->line('close'); ?>
                                            </a>
                                            <a href="#0" class="btn btn-warning p-1 mr-1 executeInvoiceDelete" id="save_invoice">
                                                Delete Invoice
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </page>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="ExcelExportModal" tabindex="-1" aria-labelledby="ExcelExportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content position-relative p-3" style="background-color: #f5f5f5;">
            <!-- <form action="no-action" method="POST" id="search_form"> -->
            <div class="modal-body" style="background-color: #f5f5f5;">
                <div class="close_modal" id="close_ExportModal" rel-export="true">
                    <i class="fas fa-times-circle text-danger"></i>
                </div>
                <div class="d-flex flex-column justify-content-center align-items-center w-75 excel-container">
                    <div class="excelTitle">
                        Filter export by :
                    </div>
                    <div class="ExcelFilteration">
                        <div class="label-excel-wrapper">
                            <input type="checkbox" name="exportByCustome" id="exportByCustomer" rel-exportby="customer">
                            <label for="exportByCustomer">By Customer:</label>
                        </div>
                        <div class="exportChoice_wrapper">
                            <select name="" id="selectCustomer" class="w-100"></select>
                        </div>
                    </div>
                    <hr class="w-100 mx-auto bg-success">
                    <div class="ExcelFilteration">
                        <div class="label-excel-wrapper">
                            <input type="checkbox" name="exportByInvoice" id="exportByInvoice" rel-exportby="invoice">
                            <label for="exportByInvoice">By Invoice:</label>
                        </div>
                        <div class="exportChoice_wrapper">
                            <select name="" id="selectInvoiceFrom" class="w-100 mb-2"></select>
                            <select name="" id="selectInvoiceTo" class="w-100"></select>
                        </div>
                    </div>
                    <hr class="w-100 mx-auto bg-success">
                    <div class="ExcelFilteration">
                        <div class="label-excel-wrapper">
                            <input type="checkbox" name="exportByDate" id="exportByDate" rel-exportby="date">
                            <label for="exportByDate">By Date:</label>
                        </div>
                        <div class="exportChoice_wrapper">
                            <input type="text" placeholder="From Date" name="invoice_date" id="invoiceDateFrom" class="datepicker form-control" />
                            <input type="text" placeholder="To Date" name="invoice_date" id="invoiceDateTo" class="datepicker form-control" />
                        </div>
                    </div>
                    <div class="excel_execute w-100 mt-3">
                        <button class="btn btn-primary btn-sm p-1 float-start" id="buildExcel">
                            Export
                        </button>
                    </div>
                </div>
            </div>
            <!-- </form> -->
        </div>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.5.2/bootbox.min.js" integrity="sha512-RdSPYh1WA6BF0RhpisYJVYkOyTzK4HwofJ3Q7ivt/jkpW6Vc8AurL1R+4AUcvn9IwEKAPm/fk7qFZW3OuiUDeg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.0/js/bootstrap-datepicker.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.0/css/bootstrap-datepicker.css">

<script>
    $(document).ready(function() {
        let itemAddition = 0;
        var total_before_vat = 0;
        var vat = 0;
        var total = 0;



        function isValidDate(s) {
            // Assumes s is "mm/dd/yyyy"
            if (!/^\d\d\/\d\d\/\d\d\d\d$/.test(s)) {
                return false;
            }
            const parts = s.split('/').map((p) => parseInt(p, 10));
            parts[0] -= 1;
            const d = new Date(parts[2], parts[0], parts[1]);
            return d.getMonth() === parts[0] && d.getDate() === parts[1] && d.getFullYear() === parts[2];
        }
        $(document).on('click', '.add_invoice_button', function() {
            $('.next-stage').css('display', 'block');

            if ($('#myModal > .modal-dialog').hasClass('modal-lg')) {
                $('#myModal > .modal-dialog').removeClass('modal-lg');
            }
            if ($('#DeleteInvoice > .modal-dialog').hasClass('modal-lg')) {
                $('#myModal > .modal-dialog').removeClass('modal-lg');
            }
        });
        // $(document).on('change', '#invoice_date', function(event) {
        //     if (!isValidDate($(this).val())) {
        //         $(this).val("");
        //     }
        // });
        $(document).on('click', '.next-stage', function(event) {
            let checkArray = [];
            let elem = $(this);
            let isDeleteModal = elem.attr('rel-delete') === "true" ? true : false;
            let parentPageOne = elem.parent().parent();
            let inputArray = parentPageOne.find('input');
            $.each(inputArray, function(index, el) {
                let elName = el.getAttribute('name');
                if (elName == "boss_Comment" || elName == "custComment") {
                    checkArray.push(true);
                } else {
                    if (el.value == "" || el.value == 0 || el.value == -1) {
                        checkArray.push(false);
                        el.classList.add('is-invalid');
                    } else {
                        el.classList.add('is-valid');
                        checkArray.push(el.value);
                    }
                }
            });
            if (!isDeleteModal) {
                $.each($('#invoice_for'), function(index, el) {
                    if (el.value == 0 ||
                        el.value == "" ||
                        el.value == undefined ||
                        el.value == null ||
                        el.value < 0) {
                        checkArray.push(false);
                        el.parentElement.style.border = "2px solid red";
                        el.parentElement.style.borderRadius = "5px";
                    } else {
                        el.parentElement.style.border = "2px solid green";
                        el.parentElement.style.borderRadius = "5px";
                        checkArray.push(el.value);
                    }
                });
            }
            if ($.inArray(false, checkArray) !== -1) {
                console.log('you forgot an input');
            } else {
                let date = $("#invoice_date").val();
                let comment = $("#custComment").val();
                let credit = $("#customer_credit").val();
                let customer = $('#invoice_for').find('option:selected').text();
                let elem = $(this);
                elem.parent().parent().parent().find('page').show();
                $("#customer").html("לקוח: " + customer);
                $("#cust_comment").val(comment);
                $("#invoice_date1").val(date);
                $("#credit1").val(credit);
                let parentModal = parentPageOne.parent().parent().parent().parent().parent();
                parentModal.addClass('modal-lg');
                elem.parent().parent().hide();
            }
        });
        $('#DeleteInvoice').on('hidden.bs.modal', function(e) {
            let elem = $(this);
            elem.find('.first-stage').show();
            elem.find('.modal-dialog').removeClass('modal-lg');
            elem.find('page').hide();
        });
        $('#myModal').on('hidden.bs.modal', function(e) {
            let elem = $(this);
            elem.find('.first-stage').show();
            elem.find('.modal-dialog').removeClass('modal-lg');
            elem.find('page').hide();
        });
        $('.reverse-stage').on('click', function() {
            let elem = $(this);
            let isDeleteModal = elem.attr('rel-delete') === "true" ? true : false;

            if (isDeleteModal) {
                $('#DeleteInvoice .modal-dialog').removeClass('modal-lg');
            } else {
                $('#myModal .modal-dialog').removeClass('modal-lg');
            }

            elem.parent().parent().parent().parent().parent().parent().find('.first-stage').show();
            elem.parent().parent().parent().parent().parent().hide();
        });
        $('#dt_basic2').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'dt-buttons col-sm-6 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": [],
            "processing": false,
            "bStateSave": false,
            "dom": 'Blfrtip',
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "הכל"]
            ],
            "pageLength": 20,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "sScrollY": 500,
            "bScrollCollapse": true,
            "scrollX": true,
            "oLanguage": {
                "sProcessing": "מעבד...",
                "sZeroRecords": "לא נמצאו רשומות מתאימות",
                "sInfo": "_START_ עד _END_ מתוך _TOTAL_ רשומות",
                "sInfoEmpty": "0 עד 0 מתוך 0 רשומות",
                "sInfoFiltered": "(מסונן מסך _MAX_  רשומות)",
                "sInfoPostFix": "",
                "sUrl": "",
                "oPaginate": {
                    "sFirst": "ראשון",
                    "sPrevious": "קודם",
                    "sNext": "הבא",
                    "sLast": "אחרון"
                }
            },
            orderCellsTop: true,
            fixedHeader: false,
            searching: false
        });
        $("#firstPayDate").datepicker({
            dateFormat: 'dd/mm/yy',
            defaultDate: "now",
            changeMonth: true,
            numberOfMonths: 2,
            isRTL: true,
            prevText: '<i class="fa fa-chevron-left"></i>',
            nextText: '<i class="fa fa-chevron-right"></i>',
            onClose: function(selectedDate) {
                $("#firstPayToDate").datepicker("option", "minDate", selectedDate);
            }
        });
        $("#firstPayToDate").datepicker({
            dateFormat: 'dd/mm/yy',
            defaultDate: "now",
            changeMonth: true,
            numberOfMonths: 2,
            isRTL: true,
            prevText: '<i class="fa fa-chevron-left"></i>',
            nextText: '<i class="fa fa-chevron-right"></i>',
            onClose: function(selectedDate) {
                $("#firstPayDate").datepicker("option", "maxDate", selectedDate);
            }
        });
        $(document).on('click', '#close_invoiceForm, #close_modal, #close_DeleteModal, #close_ExportModal', function() {

            let elem = $(this);
            let isDeleteModal = elem.attr('rel-delete') === "true" ? true : false;

            let isExportModal = elem.attr('rel-export') === "true" ? true : false;

            if (isExportModal) {
                $('#ExcelExportModal').modal('hide');
            }

            if (isDeleteModal) {
                $('#DeleteInvoice').modal('hide');
                $('#DeleteInvoice').find('modal-dialog').removeClass('modal-lg');
            } else {
                $('#myModal').modal('hide');
                $('#DeleteInvoice').find('modal-dialog').removeClass('modal-lg');
            }
        });
        $(document).on('click', '.cancel_invoice', function() {

            $('#deleteInvoiceForm').css('display', '');
            $('.next-stage').css('display', 'block');
            $('#DeleteInvoice > .modal-dialog').removeClass('modal-xl');
            $('#DeleteInvoice .first-stage').removeClass('col-md-4 col-sm-4 col-xs-4');

            $('.executeInvoiceDelete').css('display', 'block');

            let elem = $(this);
            let data = {};
            if (elem.attr("rel-invoice") === "-1") {
                bootbox.alert("Please Select an invoice from the table below to continue");
                $('#DeleteInvoice').modal('hide');
            } else {
                data = {
                    id: elem.attr("rel-invoice"),
                }

                $.post(root + 'admin/invoices/getSupplierInvoiceData', data, function(d) {
                    if (d.result == true) {
                        $('#DeleteInvoice .invoice_id_value').text(`${d.data.invoice_info.invoice_id}`);
                        $('#fill_invoice_code').val(`${d.data.invoice_info.invoice_id}`);
                        $('#fill_customer_credit').val(`${d.data.invoice_info.supplierCredit}`);
                        $('#fill_credit1').val(`${d.data.invoice_info.supplierCredit}`);
                        $('.invoiceCodeLabel').text(`${d.data.invoice_info.invoice_id}`);
                        $('#fill_invoice_date').val(`${d.data.invoice_info.invoice_date}`);
                        $('#fill_boss_Comment').val(`${d.data.invoice_info.bossComment}`);
                        $('#fill_customer').val(`${d.data.invoice_info.supplierName}`);
                        $('#fill_warehouse').val(`${d.data.invoice_info.storeName}`);
                        $('#fill_customer2').text(`${d.data.invoice_info.supplierName}`);
                        $('.fill_cust_comment').val(`${d.data.invoice_info.custComment}`);
                        $('#fill_comment1').val(`${d.data.invoice_info.comment1}`);
                        $('#fill_comment2').val(`${d.data.invoice_info.comment2}`);
                        $('#fill_invoice_date1').val(`${d.data.invoice_info.invoice_date}`);
                        $('.executeInvoiceDelete').attr('rel-invoice', d.data.invoice_info.invoice_id);

                        let productsRows = ``;
                        let items = d.data.items;

                        for (let i = 0; i < items.length; i++) {
                            productsRows += `
                            <tr class="items">
                                <td colspan="3" style="width: 40%;">
                                    <input type="text" value="${items[i].product_code}" class="item_code form-control text-center" readonly/>
                                </td>
                                <td>
                                    <input type="text" value="${items[i].item_title}" class="item_product form-control text-center" readonly/>
                                </td>
                                <td>
                                    <input type="text" value="${items[i].unit}" class="item_unit form-control text-center" readonly/>
                                </td>
                                <td>
                                    <input type="text" value="${items[i].item_price}" class="item_price form-control text-center" readonly/>
                                </td>
                                <td>
                                    <input type="text" value="${items[i].full_price}" class="full_price form-control text-center" readonly="readonly" style="width: 100%;"/>
                                </td>
                            </tr>`
                        }

                        $('#fill_items').html(productsRows);
                        calcTotal();
                    }
                }, 'json');
            }
        });
        $(document).on('click', '.view_invoice', function() {

            $('#deleteInvoiceForm').css('display', 'flex');
            $('.next-stage').css('display', 'none');
            $('.reverse-stage').css('display', 'none');
            $('#DeleteInvoice > .modal-dialog').addClass('modal-xl');
            $('#DeleteInvoice page').show();
            $('#DeleteInvoice .first-stage').addClass('col-md-4 col-sm-4 col-xs-4');
            $('.executeInvoiceDelete').css('display', 'none');


            let elem = $(this);
            let data = {};
            if (elem.attr("rel-invoice") === "-1") {
                bootbox.alert("Please Select an invoice from the table below to continue");
                $('#DeleteInvoice').modal('hide');
            } else {
                data = {
                    id: elem.attr("rel-invoice"),
                }

                $.post(root + 'admin/invoices/getSupplierInvoiceData', data, function(d) {
                    if (d.result == true) {
                        let data = d.data.invoice_info;
                        $('#DeleteInvoice .invoice_id_value').text(`${data.invoice_id}`);
                        $('#fill_invoice_code').val(`${data.invoice_id}`);
                        $('#fill_customer_credit').val(`${data.supplierCredit}`);
                        $('#fill_credit1').val(`${data.supplierCredit}`);
                        $('.invoiceCodeLabel').text(`${data.invoice_id}`);
                        $('#fill_invoice_date').val(`${data.invoice_date}`);
                        $('#fill_boss_Comment').val(`${data.bossComment}`);
                        $('#fill_customer').val(`${data.supplierName}`);
                        $('#fill_warehouse').val(`${data.storeName}`);
                        $('#fill_customer2').text(`${data.supplierName}`);
                        $('.fill_cust_comment').val(`${data.custComment}`);
                        $('#fill_comment1').val(`${data.comment1}`);
                        $('#fill_comment2').val(`${data.comment2}`);
                        $('#fill_invoice_date1').val(`${data.invoice_date}`);
                        $('.executeInvoiceDelete').attr('rel-invoice', data.invoice_id);

                        let productsRows = ``;
                        let items = d.data.items;

                        for (let i = 0; i < items.length; i++) {
                            productsRows += `
                            <tr class="items">
                                <td colspan="3" style="width: 40%;">
                                    <input type="text" value="${items[i].product_code}" class="item_code form-control text-center" readonly/>
                                </td>
                                <td>
                                    <input type="text" value="${items[i].item_title}" class="item_product form-control text-center" readonly/>
                                </td>
                                <td>
                                    <input type="text" value="${items[i].unit}" class="item_unit form-control text-center" readonly/>
                                </td>
                                <td>
                                    <input type="text" value="${items[i].item_price}" class="item_price form-control text-center" readonly/>
                                </td>
                                <td>
                                    <input type="text" value="${items[i].full_price}" class="full_price form-control text-center" readonly="readonly" style="width: 100%;"/>
                                </td>
                            </tr>`
                        }

                        $('#fill_items').html(productsRows);
                        calcTotal();
                    }
                }, 'json');
            }
        });
        $(document).on('dblclick', '#dt_basic2 tr', function() {

            $('#deleteInvoiceForm').css('display', 'flex');
            $('.next-stage').css('display', 'none');
            $('.reverse-stage').css('display', 'none');
            $('#DeleteInvoice > .modal-dialog').addClass('modal-xl');
            $('#DeleteInvoice page').show();
            $('#DeleteInvoice .first-stage').addClass('col-md-4 col-sm-4 col-xs-4');
            $('.executeInvoiceDelete').css('display', 'none');


            let elem = $(this);
            let data = {};
            if (elem.attr("rel-invoice") === "-1") {
                bootbox.alert("Please Select an invoice from the table below to continue");
                $('#DeleteInvoice').modal('hide');
            } else {
                data = {
                    id: elem.attr("rel-invoice"),
                }

                $.post(root + 'admin/invoices/getSupplierInvoiceData', data, function(d) {
                    if (d.result == true) {
                        let data = d.data.invoice_info;
                        $('#DeleteInvoice .invoice_id_value').text(`${data.invoice_id}`);
                        $('#fill_invoice_code').val(`${data.invoice_id}`);
                        $('#fill_customer_credit').val(`${data.supplierCredit}`);
                        $('#fill_credit1').val(`${data.supplierCredit}`);
                        $('.invoiceCodeLabel').text(`${data.invoice_id}`);
                        $('#fill_invoice_date').val(`${data.invoice_date}`);
                        $('#fill_boss_Comment').val(`${data.bossComment}`);
                        $('#fill_customer').val(`${data.supplierName}`);
                        $('#fill_warehouse').val(`${data.storeName}`);
                        $('#fill_customer2').text(`${data.supplierName}`);
                        $('.fill_cust_comment').val(`${data.custComment}`);
                        $('#fill_comment1').val(`${data.comment1}`);
                        $('#fill_comment2').val(`${data.comment2}`);
                        $('#fill_invoice_date1').val(`${data.invoice_date}`);
                        $('.executeInvoiceDelete').attr('rel-invoice', data.invoice_id);

                        let productsRows = ``;
                        let items = d.data.items;

                        for (let i = 0; i < items.length; i++) {
                            productsRows += `
                <tr class="items">
                    <td colspan="3" style="width: 40%;">
                        <input type="text" value="${items[i].product_code}" class="item_code form-control text-center" readonly/>
                    </td>
                    <td>
                        <input type="text" value="${items[i].item_title}" class="item_product form-control text-center" readonly/>
                    </td>
                    <td>
                        <input type="text" value="${items[i].unit}" class="item_unit form-control text-center" readonly/>
                    </td>
                    <td>
                        <input type="text" value="${items[i].item_price}" class="item_price form-control text-center" readonly/>
                    </td>
                    <td>
                        <input type="text" value="${items[i].full_price}" class="full_price form-control text-center" readonly="readonly" style="width: 100%;"/>
                    </td>
                </tr>`
                        }

                        $('#fill_items').html(productsRows);
                        calcTotal();
                        $('#DeleteInvoice').modal('show');

                    }
                }, 'json');
            }
        });
        $('.executeInvoiceDelete').on('click', function() {
            let text = "Are you sure you want to delete this invoice";
            let elem = $(this);
            var dialog = bootbox.dialog({
                title: 'Invoice Cancelation',
                message: "<p>Are you sure you want to delete this invoice ?</p>",
                size: 'small',
                buttons: {
                    cancel: {
                        label: "No",
                        className: 'btn-primary',
                        callback: function() {
                            console.log('Custom cancel clicked');
                        }
                    },
                    ok: {
                        label: "Yes",
                        className: 'btn-danger',
                        callback: function() {
                            var data = {};
                            data.invoice_id = elem.attr('rel-invoice');
                            data.deleteComment = $('#fill_comment2').val();
                            $.post(root + 'admin/invoices/deleteSupplierInvoiceOnly', data, function(d) {
                                if (d.result == true) {
                                    bootbox.alert("Invoice Deleted successfully");
                                    location.reload()
                                } else {
                                    bootbox.alert("An Error Occurred");
                                }
                            }, 'json');
                            console.log('Custom OK clicked');
                        }
                    }
                }
            });
        });
        $('.datepicker').datepicker({
            dateFormat: "dd/mm/yy",
            isRTL: true,
            prevText: '<i class="fa fa-chevron-trash"></i>',
            nextText: '<i class="fa fa-chevron-right"></i>',
        });
        $('#add_item').on('click', function() {
            if (itemAddition < 19) {
                var $table = $('#invoice_table');
                let newRow = `
                            <tr class="items">
                                <td colspan="3" style="width: 60%;"> <select style="width:400px;" name="items[product_id][]" class="select2Custom"></select>
                                <input type="hidden" name="items[code][]">
                                </td>
                                <td> <input type="text" value="" name="items[description][]" class="item_desc form-control" readonly="readonly"/></td>
                                <td> <input type="text" value="" name="items[unit][]" class="item_unit form-control" /></td>
                                <td> <input type="text" value="" name="items[price][]" class="item_price form-control" /></td>
                                <td> <input type="text" value="" name="items[full_price][]" class="full_price form-control" readonly="readonly" /></td>
                                <td>
                                    <div href="#0" class="remove_this_item btn btn-sm bg-danger text-white"><i class="fa fa-times"></i></div>
                                </td>
                            </tr>`;
                $(newRow).insertBefore('#btns_group');
                $('.select2Custom').select2({
                    placeholder: 'חפש פריטים',
                    selectOnClose: false,
                    tags: true,
                    ajax: {
                        dataType: "json",
                        url: root + 'admin/invoices/getItems',
                        processResults: function(data) {
                            return {
                                results: data.results
                            }
                        }
                    },
                    "language": {
                        "noResults": function() {
                            return "חפדש פריטים";
                        }
                    },
                    theme: "bootstrap-5"
                });
                calcTotal();
                itemAddition++;
            } else {
                alert("Only 20 are allowed");
            }
        });
        $('#add_payment_line').on('click', function() {
            var $table = $('#payment_table');
            var new_line = $table.find('tr.payments').first().clone();
            new_line.find("input.total_payment").val("");
            new_line.append('<a href="#0" class="remove_this_payment btn bg-danger btn-xs text-white"><i class="fa fa-times"></i></a>');
            new_line.insertBefore('#btns_group_payments');
        });
        $(document).on('click', '.remove_this_item', function() {
            var elem = $(this);
            var items = $(this).parent().parent().parent().find('tr.items').length;
            if( items <= 1 ){
                elem.parent().parent().find('input, select').val("");
            }else{
                elem.parent().parent().remove();
            }
            calcTotal();
            itemAddition--;
        });
        $('#save_invoice').on('click', function() {
            let checkArray = [];
            let checkFlag = false;
            let inputArray = $("#invoice_table .items input");
            // inputArray.push($('#page_one select'));

            $.each(inputArray, function(index, el) {
                if (el.value == "" || el.value == 0 || el.value == -1) {
                    checkArray.push(false);
                    el.style.border = '2px solid red';
                } else {
                    el.style.border = '2px solid green';
                    checkArray.push(el.value);
                }
            });

            $.each($('#invoice_table .items .select2Custom'), function(index, el) {
                if (el.value == 0 || el.value == "" || el.value == undefined || el.value == null || el.value < 0) {
                    checkArray.push(false);
                    // el.parentElement.style.border = "1px solid red";
                    el.parentElement.style.backgroundColor = "#df6d6d";
                } else {
                    el.parentElement.style.backgroundColor = "#6ddf9d";
                    // el.parentElement.style.border = "2px solid green";
                    checkArray.push(el.value);
                }
            });

            if ($.inArray(false, checkArray) !== -1) {
                console.log('you forget an input');
            } else {
                $('#createInvoiceForm').submit();
            }
        });
        $('#invoice_for').on('change', function() {
            var data = {};
            data.supplier_id = $(this).val();
            $.post(root + 'admin/invoices/getSupplierDetailsforInvoice', data, function(d) {
                if (d.result == true) {
                    $('#customer_credit').val(d.credit);
                } else {
                    $('#customer_credit').val("");
                }

            }, 'json');
        });
        $(document).on('change', '.item_price', function() {
            calcTotal();
        });
        $(document).on('change', '.item_unit', function() {
            calcTotal();
        });
        $(document).on('change', '.select2Custom', function() {
            var elem = $(this);
            var data = {};
            data.id = $(this).val();
            data.text = $(this).find('option:selected').text();

            elem.parent().find('input[type="hidden"]').val(data.text);

            $.post(root + 'admin/invoices/getItemPrice', data, function(d) {
                console.log(d);
                if (d.id !== undefined) {
                    elem.find('option:selected').val(d.id);
                }
                if (d.price) {
                    elem.parent().parent().find('.item_price').val(d.price);
                    calcTotal();
                }
                if (d.name) {
                    elem.parent().parent().find('.item_desc').val(d.name);
                    calcTotal();
                }
            }, 'json');
        });

        function calcTotal() {
            var full_total = 0;
            $(".item_price").each(function(index) {
                var elem = $(this);
                var price = Number(elem.val());
                var unit = Number(elem.parent().parent().find('.item_unit').val());
                var priceF = price * unit;
                elem.parent().parent().find('.full_price').val(priceF);
                full_total = full_total + priceF;
            });
            var before_vat = full_total / 1.17;
            var vat = full_total - before_vat;
            $('.fill_total_before_vat').val(before_vat.toFixed(2));
            $('.fill_vat').val(vat.toFixed(2));
            $('.fill_total').val(full_total.toFixed(2));
        }
        $('.excel_exporter').on('click', () => {
            $('#selectCustomer').select2({
                placeholder: 'Search customers',
                selectOnClose: false,
                tags: true,
                dropdownParent: $('#ExcelExportModal'),
                ajax: {
                    dataType: "json",
                    url: root + 'admin/invoices/getCustomersAjax',
                    processResults: function(data) {
                        return {
                            results: data.results
                        }
                    }
                },
                "language": {
                    "noResults": function() {
                        return "Search Customers";
                    }
                },
                theme: "bootstrap-5"
            });

            $('#selectInvoiceFrom').select2({
                placeholder: 'From Invoice',
                selectOnClose: false,
                tags: true,
                dropdownParent: $('#ExcelExportModal'),
                ajax: {
                    dataType: "json",
                    url: root + 'admin/invoices/getInvoicesAjax',
                    processResults: function(data) {
                        return {
                            results: data.results
                        }
                    }
                },
                "language": {
                    "noResults": function() {
                        return "Search Customers";
                    }
                },
                theme: "bootstrap-5"
            });

            $('#selectInvoiceTo').select2({
                placeholder: 'To Invoice',
                selectOnClose: false,
                tags: true,
                dropdownParent: $('#ExcelExportModal'),
                ajax: {
                    dataType: "json",
                    url: root + 'admin/invoices/getInvoicesAjax',
                    processResults: function(data) {
                        return {
                            results: data.results
                        }
                    }
                },
                "language": {
                    "noResults": function() {
                        return "Search Customers";
                    }
                },
                theme: "bootstrap-5"
            });

            // ability_ExcelExportTypes();
            // $('#selectCustomer').prop("disabled", false);
            // $('.ExcelFilteration input[rel-exportby="customer"]').prop('checked', true);
        });
        $(document).on('change', '.ExcelFilteration input[type="checkbox"]', function() {
            var elem = $(this);
            var checkbox = elem.attr("rel-exportby");
            if (checkbox != 'customer') {
                if ($('#exportByCustomer').prop('checked') == true) {
                    if (checkbox == 'invoice') {
                        $('#exportByDate').prop('checked', false);
                    }
                    if (checkbox == 'date') {
                        $('#exportByInvoice').prop('checked', false);
                    }
                } else {
                    if (checkbox == 'invoice') {
                        $('#exportByDate').prop('checked', false);
                    }
                    if (checkbox == 'date') {
                        $('#exportByInvoice').prop('checked', false);
                    }
                }
            }
        });
        $('#buildExcel').on('click', function() {
            let ajaxData = {};
            if ($('#exportByCustomer').prop("checked")) {
                ajaxData.customerId = $('#selectCustomer').val();
            }
            if ($('#exportByInvoice').prop("checked")) {
                ajaxData.invoiceFrom = $('#selectInvoiceFrom').val();
                ajaxData.invoiceTo = $('#selectInvoiceTo').val();
            }
            if ($('#exportByDate').prop("checked")) {
                ajaxData.invoiceDateFrom = $('#invoiceDateFrom').val();
                ajaxData.invoiceDateTo = $('#invoiceDateTo').val();
            }

            console.log(ajaxData);
            $.post(root + 'admin/ajax/invoiceExcelReport', ajaxData, function(response) {
                window.location.assign(root + 'assets/' + response);
            }, "json");
        });
        $(document).on('click', '#dt_basic2 tbody tr', function() {
            let elem = $(this);
            let rowAttr = elem.attr('rel-invoice');
            $('tr').css('background-color', "white");
            elem.css('background-color', "#e3edff")
            $('#deleteInvoiceButton').css('border-color', "#e9200c");
            $('#viewInvoiceButton').css('border-color', "#27b980");

            $('#deleteInvoiceButton').attr('rel-invoice', rowAttr);
            $('#viewInvoiceButton').attr('rel-invoice', rowAttr);
        });

    });
</script>
<style>
    table#dt_basic2 {
        width: 100% !important;
    }
</style>