<div id="main" role="main">
    <div id="content" style=" padding-top: 0px; ">
        <div class="row">
            <div class="col col-lg-10 table-responsive">
                <h1>
                    <?php echo $this->lang->line('payments'); ?>
                    - <?php echo $payment_types[$payment_type]->name; ?>
                </h1>
                <hr />
                <br />
                <br />
                <table class="table table-bordered" id="dt_basic2">
                    <thead>
                        <th>#</th>
                        <th><?php echo $this->lang->line('invoicing'); ?></th>
                        <th><?php echo $this->lang->line('customer'); ?></th>
                        <th><?php echo $this->lang->line('payment_method'); ?></th>
                        <th><?php echo $this->lang->line('cashbox'); ?></th>
                        <th><?php echo $this->lang->line('bank'); ?></th>
                        <th><?php echo $this->lang->line('branch_4digits'); ?></th>
                        <th><?php echo $this->lang->line('account_ccv'); ?></th>
                        <th><?php echo $this->lang->line('auth_number'); ?></th>
                        <th><?php echo $this->lang->line('debit'); ?></th>
                        <th><?php echo $this->lang->line('balance_credit'); ?></th>
                        <th><?php echo $this->lang->line('cashbox'); ?></th>
                        <th><?php echo $this->lang->line('note'); ?></th>
                        <th><?php echo $this->lang->line('date'); ?></th>
                        <th><?php echo $this->lang->line('actions'); ?></th>
                    </thead>
                    <tbody>
                        <?php foreach ($payments as $payment) { ?>
                            <tr>
                                <td><?php echo $payment->payment_id; ?></td>
                                <td>
                                    <?php if ($payment->invoice_id != 0) { ?>
                                        <a href="<?php echo site_url(); ?>admin/invoices/view/<?php echo $payment->invoice_id; ?>" class="btn btn-default"><?php echo $payment->invoice_id; ?></a>
                                    <?php }; ?>
                                </td>
                                <td>
                                    <?php if ($payment->customer_type == 0) { ?>
                                        <?php if (isset($customers[$payment->customer_id])) { ?>
                                            <?php echo $customers[$payment->customer_id]->customerName; ?>
                                        <?php }; ?>
                                    <?php } else if ($payment->customer_type == 2) { ?>
                                        <?php echo $temp_details[$payment->detail_id]->customer_name; ?>
                                    <?php } else { ?>
                                        <?php echo ''; ?>
                                    <?php }; ?>
                                </td>
                                <td><?php echo $payment_types[$payment->payment_type]->name; ?></td>
                                <td><?php echo $payment_boxes[$payment->payment_box]->name; ?></td>
                                <td><?php echo $payment->bank_visa; ?></td>
                                <td><?php echo $payment->branch_digits; ?></td>
                                <td><?php echo $payment->account_card; ?></td>
                                <td><?php echo $payment->reference_id; ?></td>
                                <td><?php if ($payment->total > 0) {
                                        echo $payment->total;
                                    }; ?></td>
                                <td><?php if ($payment->total < 0) {
                                        echo $payment->total;
                                    }; ?></td>
                                <td><?php echo $payment->notes; ?></td>
                                <td><?php echo $payment->notes2; ?></td>
                                <td><?php echo date("d/m/Y", strtotime($payment->payment_date)); ?></td>
                                <td>
                                    <?php if ($payment->is_converted == 0) { ?>
                                        <a href="#0" class="convert_box btn btn-success btn-circle" rel-id="<?php echo $payment->payment_id; ?>">
                                            <i class="fa fa-retweet"></i>
                                        </a>
                                    <?php }; ?>
                                </td>
                            </tr>
                        <?php }; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- END MAIN CONTENT -->

    </div>

</div>

<div class="modal" id="convert_box" tabindex="-1" role="dialog" aria-labelledby="convert_boxModal" aria-hidden="true" title="<?php echo $this->lang->line('transference_sunds'); ?>">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createPaymentModalTitle">
                <?php echo $this->lang->line('transference_sunds'); ?>
                </h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="no-action" method="POST" class="" id="convert_boxForm">
                    <input type="hidden" value="" id="payment_id" />
                    <div class="row">

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="payment_box"><?php echo $this->lang->line('transfer_to'); ?></label>
                            <label class="select">
                                <select name="payment_box" id="new_payment_box" class="form-control">
                                    <?php foreach ($payment_boxes as $payment_box) { ?>
                                        <option value="<?php echo $payment_box->box_id; ?>"><?php echo $payment_box->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="payment_type"><?php echo $this->lang->line('payment_method'); ?></label>
                            <label class="select">
                                <select name="payment_type" id="new_payment_type" class="form-control">
                                    <?php foreach ($payment_types as $payment_type) { ?>
                                        <option value="<?php echo $payment_type->type_id; ?>"><?php echo $payment_type->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                            <br />
                        </div>

                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
                <button type="button" class="btn btn-primary" id="convert_box_data" style="float:left;"><?php echo $this->lang->line('save'); ?></button>
            </div>
        </div>
    </div>
</div>

<style>
    ul.select2-result-sub {
        padding-right: 5px !important;
    }

    .select2-result-sub li {
        border-right: 4px solid #dadada;
    }

    .select2-results li.select2-result-with-children>.select2-result-label {
        font-weight: bold;
        background: #F44336;
        color: white;
    }

    .remove_this_item,
    .remove_this_payment {
        position: absolute;
        right: 0px;
        margin-top: 15px;
    }

    .remove_this_item:active,
    .remove_this_payment:active {
        position: absolute;
        top: auto !important;
        left: auto !important;
        right: 0px !important;
    }
</style>

<script type="text/javascript">
<?php
            $url = '';
            if( $this->session->userdata('site_lang') == 'hebrew' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
            }else if( $this->session->userdata('site_lang') == 'arabic' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
            }else if( $this->session->userdata('site_lang') == 'english' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
            }else{
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
            }
        ?>

    $(document).ready(function() {

        var oTbl1 = $('#dt_basic2').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'dt-buttons col-sm-6 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": ['copyHtml5', 'excelHtml5', 'csvHtml5', 'colvis'],
            "processing": true,
            //"serverSide": true,
            //"ajax": root + 'admin/ajax/getDataForTable',
            "bStateSave": true,
            "dom": 'Blfrtip',
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"]
            ],
            "pageLength": 20,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "language": {
                    "url": "<?php echo $url; ?>"
                },
            orderCellsTop: true,
            fixedHeader: true
        });

        oTbl1.buttons().container()
            .appendTo('.dataTables_filter');

        $('input[aria-controls="dt_basic2"]').attr('placeholder', 'חיפוש...');

        $('#dt_basic2_info').css('float', 'left').parent().css('float', 'left');
        $('.dataTables_paginate ').parent().css('float', 'right');
        $('.dataTables_paginate ').css('text-align', 'right');

        $('a.convert_box').on('click', function() {

            var payment_id = $(this).attr('rel-id');
            $('#payment_id').val(payment_id);
            $('#convert_box').modal('show');

        });

        $('#convert_box_data').on('click', function() {

            var data = {};
            data.payment_id = $('#payment_id').val();
            data.new_box = $('#new_payment_box').val();
            data.new_payment = $('#new_payment_type').val();

            $.post(root + 'admin/invoices/convertPayment', data, function(d) {

                if (d.result == true) {
                    alert("<?php echo $this->lang->line('Done'); ?>!");
                    location.reload();
                } else {
                    alert("<?php echo $this->lang->line('Error'); ?>!");
                }

            }, 'json');
        });

    });
</script>