<div id="main" role="main">
    <div id="content" style=" padding-top: 0px; ">
        <div class="row">
            <div class="col-lg-6">
                <h1><?php echo $this->lang->line('Automatic_invoice'); ?></h1>
            </div>
            <div>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover smart-form table-dark" id="dt_basic">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th><?php echo $this->lang->line('invoice_id'); ?></th>
                                <th><?php echo $this->lang->line('days'); ?></th>
                                <th><?php echo $this->lang->line('expire'); ?></th>
                                <th><?php echo $this->lang->line('counter'); ?></th>
                                <th><?php echo $this->lang->line('created_Invoice'); ?></th>
                                <th><?php echo $this->lang->line('last_update'); ?></th>
                                <th><?php echo $this->lang->line('date_creation'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($autoInvoice as $auto) { ?>
                                <?php if ($auto->invoice_type == "supplier_invoice") { ?>
                                    <tr>
                                        <td><?php echo $auto->id; ?></td>
                                        <td><a class="btn btn-datatable btn-blue-soft btn-lg" href="/admin/invoices/view/<?php echo $auto->invoice_id; ?>" target="_blank"><?php echo $auto->invoice_id; ?></a></td>
                                        <td><?php echo $auto->days; ?></td>
                                        <td><?php echo $auto->expire; ?></td>
                                        <td><?php echo $auto->counter; ?></td>
                                        <td>
                                            <?php
                                            if (!empty($auto->created_Invoice)) {
                                                foreach (explode(",", $auto->created_Invoice) as $invoice) {
                                                    echo '<a href=/admin/invoices/view/' . $invoice . ' target="_blank" class="btn btn-blue-soft btn-datatable me-1">' . $invoice . '</a>';
                                                }
                                            };
                                            ?>
                                        </td>
                                        <td><?php echo $auto->lastUpdate; ?></td>
                                        <td><?php echo $auto->dateCreation; ?></td>
                                    </tr>
                                <?php } ?>
                            <?php }; ?>
                        </tbody>
                    </table>
                </div>




            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    <?php
    $url = '';
    if ($this->session->userdata('site_lang') == 'hebrew') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    } else if ($this->session->userdata('site_lang') == 'arabic') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
    } else if ($this->session->userdata('site_lang') == 'english') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
    } else {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    }
    ?>
    $(document).ready(function() {
        var oTbl1 = $('#dt_basic').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-8'f><'dt-buttons col-sm-4 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": ['copyHtml5', 'excelHtml5', 'csvHtml5', 'colvis'],
            "processing": true,
            "bStateSave": true,
            "dom": 'Blfrtip',
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"]
            ],
            "pageLength": 20,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "language": {
                "url": "<?php echo $url; ?>"
            },

            orderCellsTop: true,
            fixedHeader: true
        });
        oTbl1.buttons().container().appendTo('.dataTables_filter');
    });
</script>