<div id="main" role="main">
    <div id="content">
        <div class="row">
            <div class="card card-body mb-2">
                <form class="" method="POST">
                    <fieldset>
                        <div class="row">
                            <div class="col-sm-2">

                                <div class="form-group">
                                    <label class="">&nbsp;</label>
                                    <div class="input">
                                        <input class="form-control text-center" name="firstPayDate" id="firstPayDate" type="text" placeholder="<?php echo $this->lang->line('fron_date'); ?>" value="<?php echo date('d/m/Y', strtotime($date_from)); ?>" autocomplete="off" style="width: 100%;" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="">&nbsp;</label>
                                    <div class="input">
                                        <input class="form-control text-center" name="firstPayToDate" id="firstPayToDate" type="text" placeholder="<?php echo $this->lang->line('to_date'); ?>" value="<?php echo date('d/m/Y', strtotime($date_to)); ?>" autocomplete="off" style="width: 100%;" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4" style="margin-top: 24px;">
                                <button class="btn btn-danger" type="submit"><i class="fa fa-search"></i><?php echo $this->lang->line('search'); ?></button>
                            </div>
                    </fieldset>
                </form>
            </div>
            <div>
                <table id="dt_basic44" class="table table-bordered table-striped ">
                    <h1> <?php echo $this->lang->line('customer'); ?>: <?php echo getSupplierName(intval($this->uri->segment(4))); ?></h1>
                    <thead>
                        <tr>
                            <th><?php echo $this->lang->line('date'); ?></th>
                            <th><?php echo $this->lang->line('item'); ?></th>
                            <th><?php echo $this->lang->line('reference_id'); ?></th>
                            <th><?php echo $this->lang->line('debit'); ?></th>
                            <th><?php echo $this->lang->line('balance_credit'); ?></th>
                            <th><?php echo $this->lang->line('balace'); ?></th>
                            <th></th>
                        </tr>
                        <tr>
                            <th colspan="5"><?php echo $this->lang->line('balance_opening'); ?></th>
                            <th><?php echo number_format($sum, 2); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($data as $payment) { ?>
                            <tr>
                                <td>
                                    <?php echo date('d/m/Y H:i', strtotime($payment->date)); ?>
                                </td>
                                <td>
                                <?php if ($payment->type == 'invoice') {
                                        echo  $this->lang->line('invoicing__supplier'); 
                                    } ?>
                                    <?php if ($payment->type == 'payment') {
                                        echo  $this->lang->line('supplier_payment'); 
                                    } ?>
                                </td>
                                <td>
                                    <?php
                                    if(!empty ($payment->reference_id)){
                                    echo $payment->reference_id; } ?>
                                </td>
                                <td>
                                    <?php if ($payment->type == 'payment') { ?>
                                        <?php $sum+= $payment->total; ?>
                                        <?php echo $payment->total; ?>
                                    <?php }; ?>
                                </td>
                                <td>
                                    <?php if ($payment->type == 'invoice') { ?>
                                        <?php $sum-= $payment->total; ?>
                                        <?php echo $payment->total; ?>
                                    <?php }; ?>
                                </td>
                                <td><?php echo number_format($sum, 2); ?></td>
                                <td>
                                    <?php if ($payment->type == 'invoice') { ?>
                                        <div class="btn-group">
                                            <a href="<?php echo site_url(); ?>admin/invoices/view/<?php echo $payment->id; ?>" target="_blank" class="btn btn-sm btn-primary"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                            <a href="<?php echo site_url(); ?>admin/invoices/view/<?php echo $payment->id; ?>" target="_blank" class="btn btn-sm btn-warning"><i class="fa fa-edit" aria-hidden="true"></i></a>
                                            <a href="<?php echo site_url(); ?>admin/invoices/view/<?php echo $payment->id; ?>" target="_blank" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        </div>
                                    <?php }; ?>
                                </td>

                            </tr>
                        <?php }; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


<script type="text/javascript">
<?php
            $url = '';
            if( $this->session->userdata('site_lang') == 'hebrew' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
            }else if( $this->session->userdata('site_lang') == 'arabic' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
            }else if( $this->session->userdata('site_lang') == 'english' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
            }else{
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
            }
        ?>
    $("#tbUser").on('click', '.btnDelete', function() {
        $(this).closest('tr').remove();
    });

    $("#firstPayDate").datepicker({
        dateFormat: 'dd/mm/yy',
        defaultDate: "now",
        changeMonth: true,
        numberOfMonths: 2,
        isRTL: true,
        prevText: '<i class="fa fa-chevron-left"></i>',
        nextText: '<i class="fa fa-chevron-right"></i>',
        onClose: function(selectedDate) {
            $("#firstPayToDate").datepicker("option", "minDate", selectedDate);
        }
    });
    $("#firstPayToDate").datepicker({
        dateFormat: 'dd/mm/yy',
        defaultDate: "now",
        changeMonth: true,
        numberOfMonths: 2,
        isRTL: true,
        prevText: '<i class="fa fa-chevron-left"></i>',
        nextText: '<i class="fa fa-chevron-right"></i>',
        onClose: function(selectedDate) {
            $("#firstPayDate").datepicker("option", "maxDate", selectedDate);
        }
    });
    $(document).ready(function() {
        var oTbl1 = $('#dt_basic44').DataTable({
            select: true,
            dom: 'Blfrtip',
            buttons: [ 'excelHtml5'],
            "pagingType": "full_numbers",
            "lengthMenu": [ [10, 25, 50, -1], [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"] ],
            "pageLength": 20,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "language": { "search": '', searchPlaceholder: "<?php echo $this->lang->line('search1'); ?>..." },
            "language": {
                    "url": "<?php echo $url; ?>"
                },

            orderCellsTop: true,
            fixedHeader: true
    });
    oTbl1.buttons().container().appendTo( '.dataTables_filter' );
});
</script>