<script src="https://cdn.lordicon.com/libs/mssddfmo/lord-icon-2.1.0.js"></script>
<div id="main p-0" role="main">
    <!-- <div class="header-bg shadow-sm p-0" style="background: url(https://images.pexels.com/photos/1475033/pexels-photo-1475033.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=750&w=1260)"> -->
    <!-- <div class="header-bg shadow-lg p-0" style="background: url(https://images.pexels.com/photos/1487834/pexels-photo-1487834.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=750&w=1260)"></div> -->
    <div id="content" style=" padding-top: 0px; ">
        <div class="container">
            <div class="row mt-3 justify-content-center">
                <div class="header_invoice_wrapper shadow">
                    <div class="fs-1 w-25 text-white d-flex align-items-center"><?php echo $this->lang->line('warehouses'); ?></div class="fs-1">
                    <div class="new_invoice_btn">
                        <button type="button" class="shadow-lg add_invoice_button" data-bs-toggle="collapse" href="#add_warehouse" role="button" aria-expanded="false" aria-controls="add_warehouse" title="<?php echo $this->lang->line('warehouses'); ?>">
                            <lord-icon src="https://cdn.lordicon.com/mecwbjnp.json" trigger="loop" delay="1000" colors="primary:#356359,secondary:#00bcd4" style="width:32px;height:32px">
                            </lord-icon>
                            <span class="pt-1 text-dark">
                                <?php echo $this->lang->line('new_warehouse'); ?>
                            </span>
                        </button>
                        <button title="Change status" type="button" class="shadow-lg excel_exporter cancel_invoice p-2" style="width: 50px;" id="refresh_status" rel-warehouse="-1">
                            <i class="fas fa-sync-alt"></i>
                        </button>
                        <a href="<?php print site_url(); ?>admin/warehouse/view/<?php $warehouse_id ?>" type="button" class="shadow-lg excel_exporter view_warehouse p-2" rel-warehouse="-1" style="width: 50px;">
                            <i class="pt-1 me-1 fas fa-eye text-success"></i>
                        </a>
                    </div>
                </div>
                <div class="collapse w-75" id="add_warehouse" style="margin-left: -320px;">
                    <div class="date-searchWrapper">
                        <div class="card p-3 w-50" style="border-radius: 0 0 20px 20px; float: left;">
                            <form class="" action="<?php echo site_url(); ?>admin/warehouse/action" method="POST">
                                <div class="d-flex justify-content-between">
                                    <div class="input" style="width: 40%;">
                                        <input type="text" id="name" name="name" value="" class="form-control" placeholder="<?php echo $this->lang->line('name'); ?>">
                                    </div>
                                    <div class="input" style="width: 40%;">
                                        <input type="text" id="address" name="address" value="" class="form-control" placeholder="<?php echo $this->lang->line('address'); ?>">
                                    </div>
                                </div>
                                <div class="d-flex  align-items-center justify-content-center">
                                    <div class="d-flex w-25 mt-3">
                                        <select name="status" id="status" class="form-select form-select-lg">
                                            <option value=""><?php echo $this->lang->line('status'); ?></option>
                                            <option value="0"> <?php echo $this->lang->line('active'); ?> </option>
                                            <option value="1"><?php echo $this->lang->line('freeze'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="d-flex  align-items-center justify-content-center">

                                    <button type="submit" class="btn btn-primary w-25 mt-3 p-1"><?php echo $this->lang->line('submit'); ?></button>

                                </div>
                            </form>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <hr class="bg-white mt-5" style="border-radius: 30px; padding: 2px;" />
                    <div class=" table-responsive card card-body">
                        <table class="table table-sm" id="dt_basic2">
                            <thead>
                                <th>#</th>
                                <th><?php echo $this->lang->line('name'); ?></th>
                                <th><?php echo $this->lang->line('address'); ?></th>
                                <th><?php echo $this->lang->line('status'); ?></th>
                            </thead>
                            <tbody>
                                <?php foreach ($warehouse as $house) { ?>
                                    <tr rel-warehouse="<?php echo $house->ID; ?>">
                                        <td><?php echo $house->ID; ?></td>
                                        <td>
                                            <?php echo $house->Name; ?>
                                        </td>
                                        <td><?php echo $house->Address; ?></td>
                                        <td>
                                            <?php if ($house->Status == 1) {
                                                echo $this->lang->line('active');
                                            } else {
                                                echo $this->lang->line('freeze');
                                            } ?>
                                        </td>
                                    </tr>
                                <?php }; ?>
                            </tbody>
                            <tfoot>
                                <!-- <tr>
                                        <td colspan="2"></td>
                                        <td><strong><?php echo number_format($balance, 2); ?></strong></td>
                                        <td colspan="3"></td>
                                    </tr> -->
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.5.2/bootbox.min.js" integrity="sha512-RdSPYh1WA6BF0RhpisYJVYkOyTzK4HwofJ3Q7ivt/jkpW6Vc8AurL1R+4AUcvn9IwEKAPm/fk7qFZW3OuiUDeg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.0/js/bootstrap-datepicker.min.js"></script>
<script src="https://cdn.datatables.net/1.11.2/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.0/css/bootstrap-datepicker.css">
<script>
    <?php
    $url = '';
    if ($this->session->userdata('site_lang') == 'hebrew') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    } else if ($this->session->userdata('site_lang') == 'arabic') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
    } else if ($this->session->userdata('site_lang') == 'english') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
    } else {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    }
    ?>
    $(document).ready(function() {
        $('#dt_basic2').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'dt-buttons col-sm-6 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": [],
            "processing": false,
            "bStateSave": false,
            "dom": 'Blfrtip',
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"]
            ],
            "pageLength": 20,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "sScrollY": 500,
            "bScrollCollapse": true,
            "scrollX": true,
            "language": {
                "url": "<?php echo $url; ?>"
            },
            orderCellsTop: true,
            fixedHeader: false,
            searching: false
        });

        $(document).on('click', '#dt_basic2 tbody tr', function() {
            let elem = $(this);
            let rowAttr = elem.attr('rel-warehouse');
            $('tr').css('background-color', "white");
            elem.css('background-color', "#e3edff")
            $('#deleteInvoiceButton').css('border-color', "#e9200c");
            $('#viewInvoiceButton').css('border-color', "#27b980");

            $('#deleteInvoiceButton').attr('rel-warehouse', rowAttr);
            $('#viewWarehouseButton').attr('rel-warehouse', rowAttr);
            $('#refresh_status').attr('rel-warehouse', rowAttr);

        });

        $('#buildExcel').on('click', function() {
            let ajaxData = {};
            if ($('#exportByCustomer').prop("checked")) {
                ajaxData.customerId = $('#selectCustomer').val();
            }
            if ($('#exportByInvoice').prop("checked")) {
                ajaxData.invoiceFrom = $('#selectInvoiceFrom').val();
                ajaxData.invoiceTo = $('#selectInvoiceTo').val();
            }
            if ($('#exportByDate').prop("checked")) {
                ajaxData.invoiceDateFrom = $('#invoiceDateFrom').val();
                ajaxData.invoiceDateTo = $('#invoiceDateTo').val();
            }

            console.log(ajaxData);
            $.post(root + 'admin/ajax/invoiceExcelReport', ajaxData, function(response) {
                window.location.assign(root + 'assets/' + response);
            }, "json");
        });
        $('#refresh_status').on('click', function() {
            let elem = $(this);
            if (elem.attr("rel-warehouse") === "-1") {
                bootbox.alert("<?php echo $this->lang->line('select_warhouse_continue'); ?>");
            } else {
                let warehouse_id = elem.attr('rel-warehouse');
                let data = {};
                data.warehouse = warehouse_id;
                $.post(root + 'admin/warehouse/changeStatus', data, function(d) {
                    if (d.result == "true") {
                        location.reload();
                    }
                }, 'json');
            }
        })

        $(document).on('click', '.view_warehouse', function() {
            let elem = $(this);
            let warehouse_id = 0
            if (elem.attr("rel-warehouse") === "-1") {
                bootbox.alert("<?php echo $this->lang->line('select_warhouse_continue'); ?>");
            } else {
                warehouse_id = elem.attr("rel-warehouse");
                window.open(`<?php echo site_url(); ?>admin/warehouse/view/${warehouse_id}`, "_blank");

            }


        });
    });
</script>
<style>
    table#dt_basic2 {
        width: 100% !important;
    }
</style>